/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AcceptCallOptions;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CommonIncomingCall;
import com.azure.android.communication.calling.ModeInCommunicationHelper;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.TelecomConnection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class IncomingCall
extends CommonIncomingCall {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    IncomingCall(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private CompletableFuture<Call> acceptWithContext(final Context context, final AcceptCallOptions options) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<Call>(){

            public Call get() {
                long options_converted = options != null ? options.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_incoming_call_accept_with_context(handle, context, options_converted, result_handle));
                Call result_object = Call.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static IncomingCall getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingCall, IncomingCall.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_incoming_call_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingCall, IncomingCall.class, false);
    }

    public CompletableFuture<Call> accept(Context context, AcceptCallOptions acceptCallOptions) {
        TelecomConnection telecomConnection;
        PermissionUtility.throwIfNotAppropriatePermissions(context, acceptCallOptions != null ? acceptCallOptions.getOutgoingVideoOptions() : null, new OutgoingAudioOptions().setMuted(false));
        CompletableFuture<Call> compCall = this.acceptWithContext(context, acceptCallOptions);
        Call call = (Call)compCall.join();
        if (acceptCallOptions != null && acceptCallOptions.getOutgoingAudioOptions() != null && acceptCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, call);
        }
        if ((telecomConnection = this.getTelecomConnection()) != null) {
            telecomConnection.accept(call);
            this.setTelecomConnection(null);
        }
        return compCall;
    }

    public CompletableFuture<Call> accept(Context context) {
        return this.accept(context, new AcceptCallOptions());
    }
}

