/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

final class InitializationOptions {
    long handle;

    InitializationOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_initialization_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public InitializationOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_initialization_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_release(this.handle));
        this.handle = 0L;
    }

    public String getDataPath() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_get_data_path(this.handle, result));
        return (String)result.value;
    }

    public InitializationOptions setDataPath(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_set_data_path(this.handle, value));
        return this;
    }

    public String getLogFileName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_get_log_file_name(this.handle, result));
        return (String)result.value;
    }

    public InitializationOptions setLogFileName(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_set_log_file_name(this.handle, value));
        return this;
    }

    public boolean isEncrypted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_get_is_encrypted(this.handle, result));
        return (Boolean)result.value;
    }

    public InitializationOptions setIsEncrypted(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_set_is_encrypted(this.handle, value));
        return this;
    }

    public boolean isStdoutLogging() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_get_stdout_logging(this.handle, result));
        return (Boolean)result.value;
    }

    public InitializationOptions setStdoutLogging(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_initialization_options_set_stdout_logging(this.handle, value));
        return this;
    }

    static InitializationOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InitializationOptions, InitializationOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_initialization_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InitializationOptions, InitializationOptions.class, false);
    }
}

