/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.LocalOutgoingVideoStreamView;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoBindingEventStateChangedEvent;
import com.azure.android.communication.calling.VideoBindingEventStateChangedListener;
import com.azure.android.communication.calling.VideoDeviceInfo;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedEvent;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedListener;
import com.azure.android.communication.calling.VideoFrameSizeChangedEvent;
import com.azure.android.communication.calling.VideoFrameSizeChangedListener;
import com.azure.android.communication.calling.VideoStreamView;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java9.util.concurrent.CompletableFuture;

class LocalOutgoingVideoStreamRenderer
implements IVideoStreamRenderer,
VideoBindingEventStateChangedListener,
VideoFrameSizeChangedListener,
VideoDeviceInfoUpdatedListener,
Closeable {
    private static final String TAG = "LocalOutgoingVideoStreamRenderer";
    private final Queue<CompletableFuture<Void>> switchSourcePendingCallbackQueue;
    private final Context context;
    private final LocalVideoStream localVideoStream;
    private final String rendererId;
    private LocalOutgoingVideoStreamView videoStreamView;
    private RendererListener rendererListener;
    private boolean isStarted = false;
    private boolean isFirstFrame = true;

    LocalOutgoingVideoStreamRenderer(Context context, LocalVideoStream localVideoStream) {
        this.context = context;
        this.localVideoStream = localVideoStream;
        this.localVideoStream.addOnBindingEventStateChangedListenerInternal(this);
        this.localVideoStream.addOnFrameSizeChangedListenerInternal(this);
        this.localVideoStream.addOnDeviceInfoUpdatedListenerInternal(this);
        this.rendererId = UUID.randomUUID().toString();
        this.switchSourcePendingCallbackQueue = new LinkedList<CompletableFuture<Void>>();
    }

    @Override
    public VideoStreamView StartPreview(CreateViewOptions options) {
        Log.debug1(TAG, "StartPreview, preview videoId: %s, rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
        if (this.isStarted) {
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED);
        }
        this.isStarted = true;
        this.videoStreamView = new LocalOutgoingVideoStreamView(this.context, this.localVideoStream, options.getScalingMode());
        Log.debug1(TAG, "StartPreview, preview videoId: %s, rendererId: %s, start preview requested", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
        this.localVideoStream.startPreviewNative(this.rendererId);
        return this.videoStreamView;
    }

    @Override
    public void StopPreview() {
        Log.debug1(TAG, "StopPreview, preview videoId: %s, rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
        if (this.isStarted) {
            this.isStarted = false;
            Log.debug1(TAG, "StopPreview, preview videoId: %s, rendererId: %s, stop preview requested", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
            this.localVideoStream.stopPreviewNative(this.rendererId);
        }
    }

    void SwitchVideoDeviceInfo(VideoDeviceInfo videoDeviceInfo, CompletableFuture<Void> completableFuture) {
        Log.debug1(TAG, "SwitchVideoDeviceInfo, preview videoId: %s, rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
        if (this.isStarted) {
            this.switchSourcePendingCallbackQueue.add(completableFuture);
            Log.debug1(TAG, "SwitchVideoDeviceInfo, preview videoId: %s, rendererId: %s, switch source requested", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
            this.videoStreamView.UnregisterSurfaceTexture();
            this.localVideoStream.switchVideoDeviceInfoNative(this.rendererId, videoDeviceInfo);
        }
    }

    @Override
    public void onVideoBindingEventStateChanged(VideoBindingEventStateChangedEvent args) {
        Log.debug1(TAG, "OnVideoBindingEventStateChanged, preview videoId: %s, rendererId: %s, state: %s", this.localVideoStream.getPreviewCorrelationId(), args.getRendererId(), args.getState().toString());
        if (!this.rendererId.equals(args.getRendererId())) {
            Log.debug1(TAG, "OnVideoBindingEventStateChanged, preview videoId: %s, rendererId: %s, returning because state belongs to a different rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId, args.getRendererId());
            return;
        }
        switch (args.getState()) {
            case CREATED: {
                if (!this.isStarted) break;
                this.videoStreamView.Init();
                break;
            }
            case RELEASED: {
                this.Dispose();
                break;
            }
            case FAILED: {
                this.Dispose();
                if (this.rendererListener == null) break;
                this.rendererListener.onRendererFailedToStart();
            }
        }
    }

    @Override
    public void onVideoFrameSizeChanged(VideoFrameSizeChangedEvent args) {
        Log.debug1(TAG, "OnFrameSizeChanged, preview videoId: %s, rendererId: %s, w: %d x h: %d", this.localVideoStream.getPreviewCorrelationId(), this.rendererId, args.getWidth(), args.getHeight());
        this.videoStreamView.UpdateVideoFrameSize(args.getWidth(), args.getHeight());
        if (this.rendererListener != null && this.isFirstFrame) {
            this.isFirstFrame = false;
            this.rendererListener.onFirstFrameRendered();
        }
    }

    @Override
    public void onVideoDeviceInfoUpdated(VideoDeviceInfoUpdatedEvent args) {
        Log.debug1(TAG, "OnVideoDeviceInfoUpdated, preview videoId: %s, rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
        if (!this.rendererId.equals(args.getRendererId())) {
            Log.debug1(TAG, "OnVideoDeviceInfoUpdated, preview videoId: %s, rendererId: %s, returning because event belongs to a different rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId, args.getRendererId());
            return;
        }
        if (!this.switchSourcePendingCallbackQueue.isEmpty()) {
            CompletableFuture<Void> completableFuture = this.switchSourcePendingCallbackQueue.remove();
            completableFuture.complete(null);
        }
    }

    @Override
    public void SetRendererListener(RendererListener rendererListener) {
        this.rendererListener = rendererListener;
    }

    @Override
    public StreamSize GetVideoFrameSize() {
        return this.videoStreamView.GetVideoFrameSize();
    }

    private void Dispose() {
        if (!this.isStarted) {
            Log.debug1(TAG, "Dispose, preview videoId: %s, rendererId: %s", this.localVideoStream.getPreviewCorrelationId(), this.rendererId);
            this.localVideoStream.removeOnBindingEventStateChangedListenerInternal(this);
            this.localVideoStream.removeOnFrameSizeChangedListenerInternal(this);
            this.videoStreamView.Dispose();
            this.videoStreamView = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.Dispose();
    }
}

