/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.TextureView;
import com.azure.android.communication.calling.CameraFacing;
import com.azure.android.communication.calling.DeviceProfile;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.calling.VideoStreamView;
import java.util.Collections;

class LocalOutgoingVideoStreamView
extends VideoStreamView
implements TextureView.SurfaceTextureListener,
VideoOrientationManager.OrientationChangedCallback {
    private static final String TAG = "LocalOutgoingVideoStreamView";
    private final LocalVideoStream localVideoStream;
    private VideoOrientationManager orientationManager;
    private int originalW = 0;
    private int originalH = 0;

    LocalOutgoingVideoStreamView(Context context, LocalVideoStream localVideoStream, ScalingMode scalingMode) {
        super(context, scalingMode);
        this.localVideoStream = localVideoStream;
        this.orientationManager = VideoOrientationManager.getInstance(context);
        this.orientationManager.addCallback(this);
        this.orientationManager.start();
    }

    void Init() {
        if (this.surfaceTexture == null) {
            Log.debug1(TAG, "Init, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
            this.textureView = new TextureView(this.context);
            this.textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.textureView.setVisibility(0);
            this.textureView.layout(0, 0, this.getRight(), this.getBottom());
            this.AddTextureView();
        } else {
            this.RegisterSurfaceTexture();
        }
    }

    private void FixVideoFrameSize() {
        this.w = this.originalW;
        this.h = this.originalH;
        CameraFacing cameraFacing = this.localVideoStream.getSource().getCameraFacing();
        int orientation = this.orientationManager.getOrientation();
        int cameraOrientation = DeviceProfile.GetCameraOrientation(cameraFacing);
        if ((cameraOrientation == 90 || cameraOrientation == 270) && orientation != 90 && orientation != 270) {
            this.w = this.originalH;
            this.h = this.originalW;
            Log.debug1(TAG, "FixVideoFrameSize, preview videoId: %s, new w: %d x h: %d, camera orientation: %d, device orientation: %d", this.localVideoStream.getPreviewCorrelationId(), this.w, this.h, cameraOrientation, orientation);
        }
        this.streamSize = new StreamSize(this.w, this.h);
    }

    void UpdateVideoFrameSize(int w, int h) {
        int orientation = this.orientationManager.getOrientation();
        Log.debug1(TAG, "UpdateVideoFrameSize, preview videoId: %s, new w: %d x h: %d, old w: %d x h: %d, device orientation: %d", this.localVideoStream.getPreviewCorrelationId(), w, h, this.originalW, this.originalH, orientation);
        this.originalW = w;
        this.originalH = h;
        this.FixVideoFrameSize();
        this.ScaleTextureView();
    }

    void RegisterSurfaceTexture() {
        if (this.surfaceTexture != null) {
            this.localVideoStream.registerView(Collections.singletonList(this.surfaceTexture));
            Log.debug1(TAG, "RegisterSurfaceTexture, preview videoId: %s, viewId: %d registered", this.localVideoStream.getPreviewCorrelationId(), System.identityHashCode(this.surfaceTexture));
        }
        this.ScaleTextureView();
    }

    void UnregisterSurfaceTexture() {
        if (this.surfaceTexture != null) {
            this.localVideoStream.unregisterView();
            Log.debug1(TAG, "UnregisterSurfaceTexture, preview videoId: %s, viewId: %d unregistered", this.localVideoStream.getPreviewCorrelationId(), System.identityHashCode(this.surfaceTexture));
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int w, int h) {
        Log.debug1(TAG, "onSurfaceTextureAvailable, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
        this.surfaceTexture = surfaceTexture;
        this.RegisterSurfaceTexture();
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        if (this.surfaceTexture != surfaceTexture) {
            Log.debug1(TAG, "onSurfaceTextureUpdated, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
            this.surfaceTexture = surfaceTexture;
            this.RegisterSurfaceTexture();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        Log.debug1(TAG, "onSurfaceTextureDestroyed, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
        this.UnregisterSurfaceTexture();
        this.CleanSurfaceTexture();
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int w, int h) {
        Log.debug1(TAG, "onSurfaceTextureSizeChanged, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
        this.ScaleTextureView();
    }

    @Override
    public void onOrientationChanged(int orientation) {
        Log.debug1(TAG, "onOrientationChanged, preview videoId: %s, device orientation: %d", this.localVideoStream.getPreviewCorrelationId(), orientation);
        this.FixVideoFrameSize();
        this.ScaleTextureView();
    }

    @Override
    protected String GetCorrelationId() {
        return this.localVideoStream.getPreviewCorrelationId();
    }

    private void CleanSurfaceTexture() {
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
            Log.debug1(TAG, "CleanSurfaceTexture, preview videoId: %s, surfaceTexture cleaned", this.localVideoStream.getPreviewCorrelationId());
        }
    }

    public void Dispose() {
        Log.debug1(TAG, "Dispose, preview videoId: %s", this.localVideoStream.getPreviewCorrelationId());
        if (this.orientationManager != null) {
            this.orientationManager.removeCallback(this);
            this.orientationManager.stop();
            this.orientationManager = null;
        }
        this.UnregisterSurfaceTexture();
        this.CleanSurfaceTexture();
        this.RemoveTextureView();
    }
}

