/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.LocalVideoStreamFeature;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.VideoEffect;
import com.azure.android.communication.calling.VideoEffectDisabledEvent;
import com.azure.android.communication.calling.VideoEffectDisabledListener;
import com.azure.android.communication.calling.VideoEffectEnabledEvent;
import com.azure.android.communication.calling.VideoEffectEnabledListener;
import com.azure.android.communication.calling.VideoEffectErrorEvent;
import com.azure.android.communication.calling.VideoEffectErrorListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LocalVideoEffectsFeature
extends LocalVideoStreamFeature {
    private List<VideoEffectEnabledListener> OnVideoEffectEnabledListeners = new CopyOnWriteArrayList<VideoEffectEnabledListener>();
    private List<VideoEffectDisabledListener> OnVideoEffectDisabledListeners = new CopyOnWriteArrayList<VideoEffectDisabledListener>();
    private List<VideoEffectErrorListener> OnVideoEffectErrorListeners = new CopyOnWriteArrayList<VideoEffectErrorListener>();

    LocalVideoEffectsFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    LocalVideoEffectsFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnVideoEffectEnabledStaticHandler(long cookie, long args) {
        LocalVideoEffectsFeature instance = LocalVideoEffectsFeature.getInstance(cookie);
        if (instance != null) {
            VideoEffectEnabledEvent args_converted = args != 0L ? VideoEffectEnabledEvent.getInstance(args, false) : null;
            for (VideoEffectEnabledListener listener : instance.OnVideoEffectEnabledListeners) {
                listener.onVideoEffectEnabled(args_converted);
            }
        }
    }

    public void addOnVideoEffectEnabledListener(VideoEffectEnabledListener listener) {
        this.OnVideoEffectEnabledListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoEffectEnabled", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_enabled(this.handle, this.getHandle(), this));
    }

    public void removeOnVideoEffectEnabledListener(VideoEffectEnabledListener listener) {
        this.OnVideoEffectEnabledListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoEffectEnabled", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_enabled(this.handle, 0L, null));
        }
    }

    private static void OnVideoEffectDisabledStaticHandler(long cookie, long args) {
        LocalVideoEffectsFeature instance = LocalVideoEffectsFeature.getInstance(cookie);
        if (instance != null) {
            VideoEffectDisabledEvent args_converted = args != 0L ? VideoEffectDisabledEvent.getInstance(args, false) : null;
            for (VideoEffectDisabledListener listener : instance.OnVideoEffectDisabledListeners) {
                listener.onVideoEffectDisabled(args_converted);
            }
        }
    }

    public void addOnVideoEffectDisabledListener(VideoEffectDisabledListener listener) {
        this.OnVideoEffectDisabledListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoEffectDisabled", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_disabled(this.handle, this.getHandle(), this));
    }

    public void removeOnVideoEffectDisabledListener(VideoEffectDisabledListener listener) {
        this.OnVideoEffectDisabledListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoEffectDisabled", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_disabled(this.handle, 0L, null));
        }
    }

    private static void OnVideoEffectErrorStaticHandler(long cookie, long args) {
        LocalVideoEffectsFeature instance = LocalVideoEffectsFeature.getInstance(cookie);
        if (instance != null) {
            VideoEffectErrorEvent args_converted = args != 0L ? VideoEffectErrorEvent.getInstance(args, false) : null;
            for (VideoEffectErrorListener listener : instance.OnVideoEffectErrorListeners) {
                listener.onVideoEffectError(args_converted);
            }
        }
    }

    public void addOnVideoEffectErrorListener(VideoEffectErrorListener listener) {
        this.OnVideoEffectErrorListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoEffectError", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_error(this.handle, this.getHandle(), this));
    }

    public void removeOnVideoEffectErrorListener(VideoEffectErrorListener listener) {
        this.OnVideoEffectErrorListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoEffectError", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_set_on_video_effect_error(this.handle, 0L, null));
        }
    }

    public boolean isEffectSupported(VideoEffect effect) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        long effect_converted = effect != null ? effect.getHandle() : 0L;
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_is_effect_supported(this.handle, effect_converted, result, errorContext), (ErrorInfo)errorContext.value);
        return (Boolean)result.value;
    }

    public void enableEffect(VideoEffect effect) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        long effect_converted = effect != null ? effect.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_enable_effect(this.handle, effect_converted, errorContext), (ErrorInfo)errorContext.value);
    }

    public void disableEffect(VideoEffect effect) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        long effect_converted = effect != null ? effect.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_effects_feature_disable_effect(this.handle, effect_converted, errorContext), (ErrorInfo)errorContext.value);
    }

    static LocalVideoEffectsFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoEffectsFeature, LocalVideoEffectsFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_local_video_stream_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoEffectsFeature, LocalVideoEffectsFeature.class, false);
    }

    private static LocalVideoEffectsFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoEffectsFeature, LocalVideoEffectsFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoEffectEnabled")) {
            this.addOnVideoEffectEnabledListener((VideoEffectEnabledListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoEffectDisabled")) {
            this.addOnVideoEffectDisabledListener((VideoEffectDisabledListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoEffectError")) {
            this.addOnVideoEffectErrorListener((VideoEffectErrorListener)eventListener);
        }
    }
}

