/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.ErrorReporting;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.IVideoStreamRenderer;
import com.azure.android.communication.calling.LocalOutgoingVideoStreamRenderer;
import com.azure.android.communication.calling.LocalVideoEffectsFeature;
import com.azure.android.communication.calling.LocalVideoStreamFeature;
import com.azure.android.communication.calling.LocalVideoStreamFeatureFactory;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingVideoStream;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.SwitchSourceTelemetryEvent;
import com.azure.android.communication.calling.VideoBindingEventStateChangedEvent;
import com.azure.android.communication.calling.VideoBindingEventStateChangedListener;
import com.azure.android.communication.calling.VideoDeviceInfo;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedEvent;
import com.azure.android.communication.calling.VideoDeviceInfoUpdatedListener;
import com.azure.android.communication.calling.VideoFrameSizeChangedEvent;
import com.azure.android.communication.calling.VideoFrameSizeChangedListener;
import com.azure.android.communication.calling.VideoStreamRenderer;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamStateChangedListener;
import com.azure.android.communication.calling.VideoStreamView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class LocalVideoStream
extends OutgoingVideoStream {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<VideoStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<VideoStreamStateChangedListener>();
    private List<VideoBindingEventStateChangedListener> OnBindingEventStateChangedListeners = new CopyOnWriteArrayList<VideoBindingEventStateChangedListener>();
    private List<VideoFrameSizeChangedListener> OnFrameSizeChangedListeners = new CopyOnWriteArrayList<VideoFrameSizeChangedListener>();
    private List<VideoDeviceInfoUpdatedListener> OnDeviceInfoUpdatedListeners = new CopyOnWriteArrayList<VideoDeviceInfoUpdatedListener>();

    LocalVideoStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    LocalVideoStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(VideoDeviceInfo camera, Context context) {
        long camera_converted = camera != null ? camera.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        PermissionUtility.throwIfNotAppropriatePermissions(context, false, true);
        Status resultStatus = NativeLibrary.sam_local_video_stream_create_video_device_info_camera_context_context(camera_converted, context, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public LocalVideoStream(VideoDeviceInfo camera, Context context) {
        super(LocalVideoStream.Create(camera, context), true);
    }

    public VideoDeviceInfo getSource() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_source(this.handle, result_handle));
        VideoDeviceInfo result_object = (Long)result_handle.value != 0L ? VideoDeviceInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private int getPreviewIdInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_preview_id_internal(this.handle, result));
        return (Integer)result.value;
    }

    @Deprecated
    public boolean isSending() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_is_sending(this.handle, result));
        return (Boolean)result.value;
    }

    private LocalVideoStreamFeature getLocalVideoEffectsFeature() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_local_video_effects_feature(this.handle, result_handle));
        LocalVideoStreamFeature result_object = (Long)result_handle.value != 0L ? Factories.LocalVideoStreamFeatureFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        LocalVideoStream instance = LocalVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoStreamStateChangedEvent args_converted = args != 0L ? VideoStreamStateChangedEvent.getInstance(args, false) : null;
            for (VideoStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onVideoStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    private static void OnBindingEventStateChangedStaticHandler(long cookie, long args) {
        LocalVideoStream instance = LocalVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoBindingEventStateChangedEvent args_converted = args != 0L ? VideoBindingEventStateChangedEvent.getInstance(args, false) : null;
            for (VideoBindingEventStateChangedListener listener : instance.OnBindingEventStateChangedListeners) {
                listener.onVideoBindingEventStateChanged(args_converted);
            }
        }
    }

    private void addOnBindingEventStateChangedListener(VideoBindingEventStateChangedListener listener) {
        this.OnBindingEventStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnBindingEventStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_binding_event_state_changed(this.handle, this.getHandle(), this));
    }

    private void removeOnBindingEventStateChangedListener(VideoBindingEventStateChangedListener listener) {
        this.OnBindingEventStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnBindingEventStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_binding_event_state_changed(this.handle, 0L, null));
        }
    }

    private static void OnFrameSizeChangedStaticHandler(long cookie, long args) {
        LocalVideoStream instance = LocalVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoFrameSizeChangedEvent args_converted = args != 0L ? VideoFrameSizeChangedEvent.getInstance(args, false) : null;
            for (VideoFrameSizeChangedListener listener : instance.OnFrameSizeChangedListeners) {
                listener.onVideoFrameSizeChanged(args_converted);
            }
        }
    }

    private void addOnFrameSizeChangedListener(VideoFrameSizeChangedListener listener) {
        this.OnFrameSizeChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnFrameSizeChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_frame_size_changed(this.handle, this.getHandle(), this));
    }

    private void removeOnFrameSizeChangedListener(VideoFrameSizeChangedListener listener) {
        this.OnFrameSizeChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnFrameSizeChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_frame_size_changed(this.handle, 0L, null));
        }
    }

    private static void OnDeviceInfoUpdatedStaticHandler(long cookie, long args) {
        LocalVideoStream instance = LocalVideoStream.getInstance(cookie);
        if (instance != null) {
            VideoDeviceInfoUpdatedEvent args_converted = args != 0L ? VideoDeviceInfoUpdatedEvent.getInstance(args, false) : null;
            for (VideoDeviceInfoUpdatedListener listener : instance.OnDeviceInfoUpdatedListeners) {
                listener.onVideoDeviceInfoUpdated(args_converted);
            }
        }
    }

    private void addOnDeviceInfoUpdatedListener(VideoDeviceInfoUpdatedListener listener) {
        this.OnDeviceInfoUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnDeviceInfoUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_device_info_updated(this.handle, this.getHandle(), this));
    }

    private void removeOnDeviceInfoUpdatedListener(VideoDeviceInfoUpdatedListener listener) {
        this.OnDeviceInfoUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnDeviceInfoUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_on_device_info_updated(this.handle, 0L, null));
        }
    }

    String getPreviewCorrelationId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_preview_correlation_id(this.handle, result));
        return (String)result.value;
    }

    void startPreviewNative(String rendererId) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_start_preview_native(this.handle, rendererId));
    }

    void stopPreviewNative(String rendererId) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_stop_preview_native(this.handle, rendererId));
    }

    void switchVideoDeviceInfoNative(String rendererId, VideoDeviceInfo videoDeviceInfo) {
        long videoDeviceInfo_converted = videoDeviceInfo != null ? videoDeviceInfo.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_switch_video_device_info_native(this.handle, rendererId, videoDeviceInfo_converted));
    }

    private CompletableFuture<Void> switchSourceInternal(final VideoDeviceInfo videoDevice) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long videoDevice_converted = videoDevice != null ? videoDevice.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_local_video_stream_switch_source_internal(handle, videoDevice_converted));
            }
        }, (Executor)executor);
    }

    void registerView(Object view) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_register_view(this.handle, view));
    }

    void unregisterView() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_unregister_view(this.handle));
    }

    static LocalVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStream, LocalVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStream, LocalVideoStream.class, false);
    }

    private static LocalVideoStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStream, LocalVideoStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((VideoStreamStateChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnBindingEventStateChanged")) {
            this.addOnBindingEventStateChangedListener((VideoBindingEventStateChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnFrameSizeChanged")) {
            this.addOnFrameSizeChangedListener((VideoFrameSizeChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnDeviceInfoUpdated")) {
            this.addOnDeviceInfoUpdatedListener((VideoDeviceInfoUpdatedListener)eventListener);
        }
    }

    VideoStreamView startPreview(Context context) {
        return this.startPreview(context, new CreateViewOptions(ScalingMode.CROP));
    }

    VideoStreamView startPreview(Context context, CreateViewOptions options) {
        IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.GetInstance(this.handle);
        if (videoStreamRenderer != null) {
            throw ErrorReporting.getCauseBySubCode(RuntimeException.class, 43228, "There is already a view attached");
        }
        videoStreamRenderer = VideoStreamRenderer.CreateInstance(this.handle, context, this);
        return videoStreamRenderer.StartPreview(options);
    }

    void stopPreview() {
        IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.GetInstance(this.handle);
        if (videoStreamRenderer != null) {
            videoStreamRenderer.StopPreview();
            VideoStreamRenderer.RemoveInstance(this.handle);
        }
    }

    public CompletableFuture<Void> switchSource(VideoDeviceInfo camera) {
        if (this.isAttachedToCall()) {
            boolean canBeSwitched = false;
            switch (this.getCallState()) {
                case CONNECTED: {
                    canBeSwitched = true;
                    break;
                }
            }
            if (!canBeSwitched) {
                return CompletableFuture.failedFuture((Throwable)new CallingCommunicationException(CallingCommunicationErrors.SWITCH_SOURCE_BLOCKED, "", "", ""));
            }
        }
        VideoDeviceInfo currentVideoDeviceInfo = this.getSource();
        SwitchSourceTelemetryEvent event = new SwitchSourceTelemetryEvent(this);
        event.sendAttempt();
        if (currentVideoDeviceInfo != camera) {
            CompletableFuture completableFuture = new CompletableFuture();
            Executors.newCachedThreadPool().submit(() -> {
                try {
                    IVideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.GetInstance(this.handle);
                    if (videoStreamRenderer != null) {
                        LocalOutgoingVideoStreamRenderer localVideoStreamRenderer = (LocalOutgoingVideoStreamRenderer)videoStreamRenderer;
                        localVideoStreamRenderer.SwitchVideoDeviceInfo(camera, (CompletableFuture<Void>)completableFuture);
                    } else {
                        this.switchVideoDeviceInfoNative("NO_RENDERER_ID", camera);
                        completableFuture.complete(null);
                    }
                    event.sendSuccess();
                }
                catch (Exception e) {
                    event.sendFailure(e.getLocalizedMessage());
                }
            });
            return completableFuture;
        }
        event.sendFailure("Attempt to switch to the same source");
        return CompletableFuture.completedFuture(null);
    }

    int getPreviewId() {
        return this.getPreviewIdInternal();
    }

    void addOnBindingEventStateChangedListenerInternal(VideoBindingEventStateChangedListener listener) {
        this.addOnBindingEventStateChangedListener(listener);
    }

    void removeOnBindingEventStateChangedListenerInternal(VideoBindingEventStateChangedListener listener) {
        this.removeOnBindingEventStateChangedListener(listener);
    }

    void addOnFrameSizeChangedListenerInternal(VideoFrameSizeChangedListener listener) {
        this.addOnFrameSizeChangedListener(listener);
    }

    void removeOnFrameSizeChangedListenerInternal(VideoFrameSizeChangedListener listener) {
        this.removeOnFrameSizeChangedListener(listener);
    }

    void addOnDeviceInfoUpdatedListenerInternal(VideoDeviceInfoUpdatedListener listener) {
        this.addOnDeviceInfoUpdatedListener(listener);
    }

    void removeOnDeviceInfoUpdatedListenerInternal(VideoDeviceInfoUpdatedListener listener) {
        this.removeOnDeviceInfoUpdatedListener(listener);
    }

    public <TLocalVideoStreamFeature extends LocalVideoStreamFeature> TLocalVideoStreamFeature feature(LocalVideoStreamFeatureFactory<TLocalVideoStreamFeature> factory) {
        return this.feature(factory.getLocalVideoStreamFeatureImpl());
    }

    private <TLocalVideoStreamFeature extends LocalVideoStreamFeature> TLocalVideoStreamFeature feature(Class<TLocalVideoStreamFeature> featureClass) {
        if (featureClass == LocalVideoEffectsFeature.class) {
            return (TLocalVideoStreamFeature)this.getLocalVideoEffectsFeature();
        }
        throw ErrorReporting.getExceptionBySubCode(43020);
    }
}

