/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.Status;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;

class NativeLibraryHelpers {
    NativeLibraryHelpers() {
    }

    static String fullMessageFromErrorContext(ErrorInfo errorContext) {
        return errorContext.Message;
    }

    static void checkStatus(Status value, ErrorInfo errorContext) {
        if (value == Status.OK) {
            return;
        }
        String fullMessage = NativeLibraryHelpers.fullMessageFromErrorContext(errorContext);
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                CallingCommunicationException nONEException = new CallingCommunicationException(CallingCommunicationErrors.NONE, fullMessage);
                nONEException.setCode(errorContext.Code);
                nONEException.setSubCode(errorContext.SubCode);
                nONEException.setMessage(errorContext.Message);
                throw nONEException;
            }
            case NO_AUDIO_PERMISSION: {
                CallingCommunicationException nOAUDIOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, fullMessage);
                nOAUDIOPERMISSIONException.setCode(errorContext.Code);
                nOAUDIOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOAUDIOPERMISSIONException.setMessage(errorContext.Message);
                throw nOAUDIOPERMISSIONException;
            }
            case NO_VIDEO_PERMISSION: {
                CallingCommunicationException nOVIDEOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, fullMessage);
                nOVIDEOPERMISSIONException.setCode(errorContext.Code);
                nOVIDEOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOVIDEOPERMISSIONException.setMessage(errorContext.Message);
                throw nOVIDEOPERMISSIONException;
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                CallingCommunicationException nOAUDIOANDVIDEOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, fullMessage);
                nOAUDIOANDVIDEOPERMISSIONException.setCode(errorContext.Code);
                nOAUDIOANDVIDEOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOAUDIOANDVIDEOPERMISSIONException.setMessage(errorContext.Message);
                throw nOAUDIOANDVIDEOPERMISSIONException;
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                CallingCommunicationException rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException = new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, fullMessage);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setCode(errorContext.Code);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setSubCode(errorContext.SubCode);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setMessage(errorContext.Message);
                throw rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException;
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                CallingCommunicationException fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, fullMessage);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setCode(errorContext.Code);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setSubCode(errorContext.SubCode);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setMessage(errorContext.Message);
                throw fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException;
            }
            case INVALID_GUID_GROUP_ID: {
                CallingCommunicationException iNVALIDGUIDGROUPIDException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, fullMessage);
                iNVALIDGUIDGROUPIDException.setCode(errorContext.Code);
                iNVALIDGUIDGROUPIDException.setSubCode(errorContext.SubCode);
                iNVALIDGUIDGROUPIDException.setMessage(errorContext.Message);
                throw iNVALIDGUIDGROUPIDException;
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                CallingCommunicationException iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, fullMessage);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setCode(errorContext.Code);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setSubCode(errorContext.SubCode);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setMessage(errorContext.Message);
                throw iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException;
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                CallingCommunicationException mULTIPLERENDERERSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, fullMessage);
                mULTIPLERENDERERSNOTSUPPORTEDException.setCode(errorContext.Code);
                mULTIPLERENDERERSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mULTIPLERENDERERSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mULTIPLERENDERERSNOTSUPPORTEDException;
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                CallingCommunicationException mULTIPLEVIEWSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, fullMessage);
                mULTIPLEVIEWSNOTSUPPORTEDException.setCode(errorContext.Code);
                mULTIPLEVIEWSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mULTIPLEVIEWSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mULTIPLEVIEWSNOTSUPPORTEDException;
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                CallingCommunicationException iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, fullMessage);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setCode(errorContext.Code);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setSubCode(errorContext.SubCode);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setMessage(errorContext.Message);
                throw iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException;
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                CallingCommunicationException nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException = new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, fullMessage);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setCode(errorContext.Code);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setSubCode(errorContext.SubCode);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setMessage(errorContext.Message);
                throw nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException;
            }
            case INVALID_SERVER_CALL_ID: {
                CallingCommunicationException iNVALIDSERVERCALLIDException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, fullMessage);
                iNVALIDSERVERCALLIDException.setCode(errorContext.Code);
                iNVALIDSERVERCALLIDException.setSubCode(errorContext.SubCode);
                iNVALIDSERVERCALLIDException.setMessage(errorContext.Message);
                throw iNVALIDSERVERCALLIDException;
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                CallingCommunicationException lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, fullMessage);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setCode(errorContext.Code);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setSubCode(errorContext.SubCode);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setMessage(errorContext.Message);
                throw lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException;
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                CallingCommunicationException iNCOMINGCALLALREADYUNPLACEDException = new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, fullMessage);
                iNCOMINGCALLALREADYUNPLACEDException.setCode(errorContext.Code);
                iNCOMINGCALLALREADYUNPLACEDException.setSubCode(errorContext.SubCode);
                iNCOMINGCALLALREADYUNPLACEDException.setMessage(errorContext.Message);
                throw iNCOMINGCALLALREADYUNPLACEDException;
            }
            case INVALID_MEETING_LINK: {
                CallingCommunicationException iNVALIDMEETINGLINKException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, fullMessage);
                iNVALIDMEETINGLINKException.setCode(errorContext.Code);
                iNVALIDMEETINGLINKException.setSubCode(errorContext.SubCode);
                iNVALIDMEETINGLINKException.setMessage(errorContext.Message);
                throw iNVALIDMEETINGLINKException;
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                CallingCommunicationException pARTICIPANTADDEDTOUNCONNECTEDCALLException = new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, fullMessage);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setCode(errorContext.Code);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setSubCode(errorContext.SubCode);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setMessage(errorContext.Message);
                throw pARTICIPANTADDEDTOUNCONNECTEDCALLException;
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                CallingCommunicationException pARTICIPANTALREADYADDEDTOCALLException = new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, fullMessage);
                pARTICIPANTALREADYADDEDTOCALLException.setCode(errorContext.Code);
                pARTICIPANTALREADYADDEDTOCALLException.setSubCode(errorContext.SubCode);
                pARTICIPANTALREADYADDEDTOCALLException.setMessage(errorContext.Message);
                throw pARTICIPANTALREADYADDEDTOCALLException;
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                CallingCommunicationException cALLFEATUREEXTENSIONNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, fullMessage);
                cALLFEATUREEXTENSIONNOTFOUNDException.setCode(errorContext.Code);
                cALLFEATUREEXTENSIONNOTFOUNDException.setSubCode(errorContext.SubCode);
                cALLFEATUREEXTENSIONNOTFOUNDException.setMessage(errorContext.Message);
                throw cALLFEATUREEXTENSIONNOTFOUNDException;
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                CallingCommunicationException dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, fullMessage);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setCode(errorContext.Code);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setSubCode(errorContext.SubCode);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setMessage(errorContext.Message);
                throw dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException;
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                CallingCommunicationException fAILEDTOHANGUPFOREVERYONEException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, fullMessage);
                fAILEDTOHANGUPFOREVERYONEException.setCode(errorContext.Code);
                fAILEDTOHANGUPFOREVERYONEException.setSubCode(errorContext.SubCode);
                fAILEDTOHANGUPFOREVERYONEException.setMessage(errorContext.Message);
                throw fAILEDTOHANGUPFOREVERYONEException;
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                CallingCommunicationException nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException = new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, fullMessage);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setCode(errorContext.Code);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setSubCode(errorContext.SubCode);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setMessage(errorContext.Message);
                throw nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException;
            }
            case DUPLICATE_DEVICE_ID: {
                CallingCommunicationException dUPLICATEDEVICEIDException = new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, fullMessage);
                dUPLICATEDEVICEIDException.setCode(errorContext.Code);
                dUPLICATEDEVICEIDException.setSubCode(errorContext.SubCode);
                dUPLICATEDEVICEIDException.setMessage(errorContext.Message);
                throw dUPLICATEDEVICEIDException;
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                CallingCommunicationException vIRTUALDEVICENOTSTARTEDException = new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, fullMessage);
                vIRTUALDEVICENOTSTARTEDException.setCode(errorContext.Code);
                vIRTUALDEVICENOTSTARTEDException.setSubCode(errorContext.SubCode);
                vIRTUALDEVICENOTSTARTEDException.setMessage(errorContext.Message);
                throw vIRTUALDEVICENOTSTARTEDException;
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                CallingCommunicationException iNVALIDVIDEOSTREAMCOMBINATIONException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, fullMessage);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setCode(errorContext.Code);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setSubCode(errorContext.SubCode);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setMessage(errorContext.Message);
                throw iNVALIDVIDEOSTREAMCOMBINATIONException;
            }
            case INVALID_VIDEO_FORMAT: {
                CallingCommunicationException iNVALIDVIDEOFORMATException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, fullMessage);
                iNVALIDVIDEOFORMATException.setCode(errorContext.Code);
                iNVALIDVIDEOFORMATException.setSubCode(errorContext.SubCode);
                iNVALIDVIDEOFORMATException.setMessage(errorContext.Message);
                throw iNVALIDVIDEOFORMATException;
            }
            case INVALID_BUFFER: {
                CallingCommunicationException iNVALIDBUFFERException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, fullMessage);
                iNVALIDBUFFERException.setCode(errorContext.Code);
                iNVALIDBUFFERException.setSubCode(errorContext.SubCode);
                iNVALIDBUFFERException.setMessage(errorContext.Message);
                throw iNVALIDBUFFERException;
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                CallingCommunicationException rAWVIDEOFRAMENOTSENTException = new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, fullMessage);
                rAWVIDEOFRAMENOTSENTException.setCode(errorContext.Code);
                rAWVIDEOFRAMENOTSENTException.setSubCode(errorContext.SubCode);
                rAWVIDEOFRAMENOTSENTException.setMessage(errorContext.Message);
                throw rAWVIDEOFRAMENOTSENTException;
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                CallingCommunicationException uNSUPPORTEDVIDEOSTREAMRESOLUTIONException = new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, fullMessage);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setCode(errorContext.Code);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setSubCode(errorContext.SubCode);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setMessage(errorContext.Message);
                throw uNSUPPORTEDVIDEOSTREAMRESOLUTIONException;
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                CallingCommunicationException fEATUREEXTENSIONNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, fullMessage);
                fEATUREEXTENSIONNOTFOUNDException.setCode(errorContext.Code);
                fEATUREEXTENSIONNOTFOUNDException.setSubCode(errorContext.SubCode);
                fEATUREEXTENSIONNOTFOUNDException.setMessage(errorContext.Message);
                throw fEATUREEXTENSIONNOTFOUNDException;
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                CallingCommunicationException vIDEOEFFECTNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, fullMessage);
                vIDEOEFFECTNOTSUPPORTEDException.setCode(errorContext.Code);
                vIDEOEFFECTNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                vIDEOEFFECTNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw vIDEOEFFECTNOTSUPPORTEDException;
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                CallingCommunicationException fAILEDTOSENDRAWAUDIOBUFFERException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, fullMessage);
                fAILEDTOSENDRAWAUDIOBUFFERException.setCode(errorContext.Code);
                fAILEDTOSENDRAWAUDIOBUFFERException.setSubCode(errorContext.SubCode);
                fAILEDTOSENDRAWAUDIOBUFFERException.setMessage(errorContext.Message);
                throw fAILEDTOSENDRAWAUDIOBUFFERException;
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                CallingCommunicationException cANNOTMUTEVIRTUALAUDIOSTREAMException = new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, fullMessage);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setCode(errorContext.Code);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setSubCode(errorContext.SubCode);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setMessage(errorContext.Message);
                throw cANNOTMUTEVIRTUALAUDIOSTREAMException;
            }
            case CAPTIONS_FAILED_TO_START: {
                CallingCommunicationException cAPTIONSFAILEDTOSTARTException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, fullMessage);
                cAPTIONSFAILEDTOSTARTException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSTARTException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSTARTException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSTARTException;
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException cAPTIONSDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, fullMessage);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw cAPTIONSDISABLEDBYCONFIGURATIONSException;
            }
            case CAPTIONS_POLICY_DISABLED: {
                CallingCommunicationException cAPTIONSPOLICYDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, fullMessage);
                cAPTIONSPOLICYDISABLEDException.setCode(errorContext.Code);
                cAPTIONSPOLICYDISABLEDException.setSubCode(errorContext.SubCode);
                cAPTIONSPOLICYDISABLEDException.setMessage(errorContext.Message);
                throw cAPTIONSPOLICYDISABLEDException;
            }
            case CAPTIONS_NOT_ACTIVE: {
                CallingCommunicationException cAPTIONSNOTACTIVEException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, fullMessage);
                cAPTIONSNOTACTIVEException.setCode(errorContext.Code);
                cAPTIONSNOTACTIVEException.setSubCode(errorContext.SubCode);
                cAPTIONSNOTACTIVEException.setMessage(errorContext.Message);
                throw cAPTIONSNOTACTIVEException;
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                CallingCommunicationException cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, fullMessage);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setCode(errorContext.Code);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setMessage(errorContext.Message);
                throw cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException;
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                CallingCommunicationException fAILEDTOSETCAPTIONLANGUAGEException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, fullMessage);
                fAILEDTOSETCAPTIONLANGUAGEException.setCode(errorContext.Code);
                fAILEDTOSETCAPTIONLANGUAGEException.setSubCode(errorContext.SubCode);
                fAILEDTOSETCAPTIONLANGUAGEException.setMessage(errorContext.Message);
                throw fAILEDTOSETCAPTIONLANGUAGEException;
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                CallingCommunicationException sETCAPTIONLANGUAGEDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, fullMessage);
                sETCAPTIONLANGUAGEDISABLEDException.setCode(errorContext.Code);
                sETCAPTIONLANGUAGEDISABLEDException.setSubCode(errorContext.SubCode);
                sETCAPTIONLANGUAGEDISABLEDException.setMessage(errorContext.Message);
                throw sETCAPTIONLANGUAGEDISABLEDException;
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                CallingCommunicationException sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException = new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, fullMessage);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setCode(errorContext.Code);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setSubCode(errorContext.SubCode);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setMessage(errorContext.Message);
                throw sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException;
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                CallingCommunicationException cAPTIONSFAILEDTOSETSPOKENLANGUAGEException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, fullMessage);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSETSPOKENLANGUAGEException;
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                CallingCommunicationException cAPTIONSSETSPOKENLANGUAGEDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, fullMessage);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setCode(errorContext.Code);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setSubCode(errorContext.SubCode);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setMessage(errorContext.Message);
                throw cAPTIONSSETSPOKENLANGUAGEDISABLEDException;
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                CallingCommunicationException gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException = new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, fullMessage);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setCode(errorContext.Code);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setSubCode(errorContext.SubCode);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setMessage(errorContext.Message);
                throw gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException;
            }
            case GET_CAPTIONS_FAILED: {
                CallingCommunicationException gETCAPTIONSFAILEDException = new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, fullMessage);
                gETCAPTIONSFAILEDException.setCode(errorContext.Code);
                gETCAPTIONSFAILEDException.setSubCode(errorContext.SubCode);
                gETCAPTIONSFAILEDException.setMessage(errorContext.Message);
                throw gETCAPTIONSFAILEDException;
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException sPOTLIGHTDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, fullMessage);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw sPOTLIGHTDISABLEDBYCONFIGURATIONSException;
            }
            case MAX_SPOTLIGHT_REACHED: {
                CallingCommunicationException mAXSPOTLIGHTREACHEDException = new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, fullMessage);
                mAXSPOTLIGHTREACHEDException.setCode(errorContext.Code);
                mAXSPOTLIGHTREACHEDException.setSubCode(errorContext.SubCode);
                mAXSPOTLIGHTREACHEDException.setMessage(errorContext.Message);
                throw mAXSPOTLIGHTREACHEDException;
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                CallingCommunicationException sPOTLIGHTPARTICIPANTEMPTYLISTException = new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, fullMessage);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setCode(errorContext.Code);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setSubCode(errorContext.SubCode);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setMessage(errorContext.Message);
                throw sPOTLIGHTPARTICIPANTEMPTYLISTException;
            }
            case SIGNALING_OPERATION_FAILED: {
                CallingCommunicationException sIGNALINGOPERATIONFAILEDException = new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, fullMessage);
                sIGNALINGOPERATIONFAILEDException.setCode(errorContext.Code);
                sIGNALINGOPERATIONFAILEDException.setSubCode(errorContext.SubCode);
                sIGNALINGOPERATIONFAILEDException.setMessage(errorContext.Message);
                throw sIGNALINGOPERATIONFAILEDException;
            }
            case MUSIC_MODE_NOT_ENABLED: {
                CallingCommunicationException mUSICMODENOTENABLEDException = new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, fullMessage);
                mUSICMODENOTENABLEDException.setCode(errorContext.Code);
                mUSICMODENOTENABLEDException.setSubCode(errorContext.SubCode);
                mUSICMODENOTENABLEDException.setMessage(errorContext.Message);
                throw mUSICMODENOTENABLEDException;
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException lOBBYDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, fullMessage);
                lOBBYDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                lOBBYDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                lOBBYDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw lOBBYDISABLEDBYCONFIGURATIONSException;
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                CallingCommunicationException lOBBYCONVERSATIONTYPENOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, fullMessage);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setCode(errorContext.Code);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setMessage(errorContext.Message);
                throw lOBBYCONVERSATIONTYPENOTSUPPORTEDException;
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                CallingCommunicationException lOBBYMEETINGROLENOTALLOWEDException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, fullMessage);
                lOBBYMEETINGROLENOTALLOWEDException.setCode(errorContext.Code);
                lOBBYMEETINGROLENOTALLOWEDException.setSubCode(errorContext.SubCode);
                lOBBYMEETINGROLENOTALLOWEDException.setMessage(errorContext.Message);
                throw lOBBYMEETINGROLENOTALLOWEDException;
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                CallingCommunicationException lOBBYPARTICIPANTNOTEXISTException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, fullMessage);
                lOBBYPARTICIPANTNOTEXISTException.setCode(errorContext.Code);
                lOBBYPARTICIPANTNOTEXISTException.setSubCode(errorContext.SubCode);
                lOBBYPARTICIPANTNOTEXISTException.setMessage(errorContext.Message);
                throw lOBBYPARTICIPANTNOTEXISTException;
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                CallingCommunicationException rEMOVEPARTICIPANTOPERATIONFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, fullMessage);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setCode(errorContext.Code);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setSubCode(errorContext.SubCode);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setMessage(errorContext.Message);
                throw rEMOVEPARTICIPANTOPERATIONFAILUREException;
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                CallingCommunicationException lOBBYADMITOPERATIONFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, fullMessage);
                lOBBYADMITOPERATIONFAILUREException.setCode(errorContext.Code);
                lOBBYADMITOPERATIONFAILUREException.setSubCode(errorContext.SubCode);
                lOBBYADMITOPERATIONFAILUREException.setMessage(errorContext.Message);
                throw lOBBYADMITOPERATIONFAILUREException;
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                CallingCommunicationException pROXYNOTAVAILABLEFORTEAMSException = new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, fullMessage);
                pROXYNOTAVAILABLEFORTEAMSException.setCode(errorContext.Code);
                pROXYNOTAVAILABLEFORTEAMSException.setSubCode(errorContext.SubCode);
                pROXYNOTAVAILABLEFORTEAMSException.setMessage(errorContext.Message);
                throw pROXYNOTAVAILABLEFORTEAMSException;
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                CallingCommunicationException fAILEDTOSETMEDIAPROXYException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, fullMessage);
                fAILEDTOSETMEDIAPROXYException.setCode(errorContext.Code);
                fAILEDTOSETMEDIAPROXYException.setSubCode(errorContext.SubCode);
                fAILEDTOSETMEDIAPROXYException.setMessage(errorContext.Message);
                throw fAILEDTOSETMEDIAPROXYException;
            }
            case MEDIA_STATISTICS_INVALID_REPORT_INTERVAL: {
                CallingCommunicationException mEDIASTATISTICSINVALIDREPORTINTERVALException = new CallingCommunicationException(CallingCommunicationErrors.MEDIA_STATISTICS_INVALID_REPORT_INTERVAL, fullMessage);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setCode(errorContext.Code);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setSubCode(errorContext.SubCode);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setMessage(errorContext.Message);
                throw mEDIASTATISTICSINVALIDREPORTINTERVALException;
            }
            case DATA_CHANNEL_FAILED_TO_START: {
                CallingCommunicationException dATACHANNELFAILEDTOSTARTException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_FAILED_TO_START, fullMessage);
                dATACHANNELFAILEDTOSTARTException.setCode(errorContext.Code);
                dATACHANNELFAILEDTOSTARTException.setSubCode(errorContext.SubCode);
                dATACHANNELFAILEDTOSTARTException.setMessage(errorContext.Message);
                throw dATACHANNELFAILEDTOSTARTException;
            }
            case DATA_CHANNEL_SENDER_CLOSED: {
                CallingCommunicationException dATACHANNELSENDERCLOSEDException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_SENDER_CLOSED, fullMessage);
                dATACHANNELSENDERCLOSEDException.setCode(errorContext.Code);
                dATACHANNELSENDERCLOSEDException.setSubCode(errorContext.SubCode);
                dATACHANNELSENDERCLOSEDException.setMessage(errorContext.Message);
                throw dATACHANNELSENDERCLOSEDException;
            }
            case DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE: {
                CallingCommunicationException dATACHANNELRANDOMIDNOTAVAILABLEException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE, fullMessage);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setCode(errorContext.Code);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setSubCode(errorContext.SubCode);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setMessage(errorContext.Message);
                throw dATACHANNELRANDOMIDNOTAVAILABLEException;
            }
            case DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT: {
                CallingCommunicationException dATACHANNELMESSAGESIZEOVERLIMITException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT, fullMessage);
                dATACHANNELMESSAGESIZEOVERLIMITException.setCode(errorContext.Code);
                dATACHANNELMESSAGESIZEOVERLIMITException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGESIZEOVERLIMITException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGESIZEOVERLIMITException;
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH: {
                CallingCommunicationException dATACHANNELMESSAGEFAILUREFORBANDWIDTHException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH, fullMessage);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setCode(errorContext.Code);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGEFAILUREFORBANDWIDTHException;
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT: {
                CallingCommunicationException dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT, fullMessage);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setCode(errorContext.Code);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException;
            }
            case INVALID_PARTICIPANT_ADDED_TO_CALL: {
                CallingCommunicationException iNVALIDPARTICIPANTADDEDTOCALLException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_PARTICIPANT_ADDED_TO_CALL, fullMessage);
                iNVALIDPARTICIPANTADDEDTOCALLException.setCode(errorContext.Code);
                iNVALIDPARTICIPANTADDEDTOCALLException.setSubCode(errorContext.SubCode);
                iNVALIDPARTICIPANTADDEDTOCALLException.setMessage(errorContext.Message);
                throw iNVALIDPARTICIPANTADDEDTOCALLException;
            }
            case INVALID_TOKEN_PROVIDER: {
                CallingCommunicationException iNVALIDTOKENPROVIDERException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_TOKEN_PROVIDER, fullMessage);
                iNVALIDTOKENPROVIDERException.setCode(errorContext.Code);
                iNVALIDTOKENPROVIDERException.setSubCode(errorContext.SubCode);
                iNVALIDTOKENPROVIDERException.setMessage(errorContext.Message);
                throw iNVALIDTOKENPROVIDERException;
            }
            case TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED: {
                CallingCommunicationException tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED, fullMessage);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setCode(errorContext.Code);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException;
            }
            case CAPTIONS_FAILED_TO_STOP: {
                CallingCommunicationException cAPTIONSFAILEDTOSTOPException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_STOP, fullMessage);
                cAPTIONSFAILEDTOSTOPException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSTOPException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSTOPException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSTOPException;
            }
            case SWITCH_SOURCE_BLOCKED: {
                CallingCommunicationException sWITCHSOURCEBLOCKEDException = new CallingCommunicationException(CallingCommunicationErrors.SWITCH_SOURCE_BLOCKED, fullMessage);
                sWITCHSOURCEBLOCKEDException.setCode(errorContext.Code);
                sWITCHSOURCEBLOCKEDException.setSubCode(errorContext.SubCode);
                sWITCHSOURCEBLOCKEDException.setMessage(errorContext.Message);
                throw sWITCHSOURCEBLOCKEDException;
            }
            case SURVEY_RATING_SCALE_OUT_OF_BOUNDS: {
                CallingCommunicationException sURVEYRATINGSCALEOUTOFBOUNDSException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_OUT_OF_BOUNDS, fullMessage);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setCode(errorContext.Code);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setSubCode(errorContext.SubCode);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setMessage(errorContext.Message);
                throw sURVEYRATINGSCALEOUTOFBOUNDSException;
            }
            case SURVEY_RATING_SCALE_INVALID_THRESHOLD: {
                CallingCommunicationException sURVEYRATINGSCALEINVALIDTHRESHOLDException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_INVALID_THRESHOLD, fullMessage);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setCode(errorContext.Code);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setSubCode(errorContext.SubCode);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setMessage(errorContext.Message);
                throw sURVEYRATINGSCALEINVALIDTHRESHOLDException;
            }
            case SURVEY_SCORE_OUT_OF_BOUNDS: {
                CallingCommunicationException sURVEYSCOREOUTOFBOUNDSException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_SCORE_OUT_OF_BOUNDS, fullMessage);
                sURVEYSCOREOUTOFBOUNDSException.setCode(errorContext.Code);
                sURVEYSCOREOUTOFBOUNDSException.setSubCode(errorContext.SubCode);
                sURVEYSCOREOUTOFBOUNDSException.setMessage(errorContext.Message);
                throw sURVEYSCOREOUTOFBOUNDSException;
            }
            case SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED: {
                CallingCommunicationException sURVEYDOUBLESUBMISSIONNOTALLOWEDException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED, fullMessage);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setCode(errorContext.Code);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setSubCode(errorContext.SubCode);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setMessage(errorContext.Message);
                throw sURVEYDOUBLESUBMISSIONNOTALLOWEDException;
            }
            case MUTE_OTHERS_FORBIDDEN: {
                CallingCommunicationException mUTEOTHERSFORBIDDENException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_FORBIDDEN, fullMessage);
                mUTEOTHERSFORBIDDENException.setCode(errorContext.Code);
                mUTEOTHERSFORBIDDENException.setSubCode(errorContext.SubCode);
                mUTEOTHERSFORBIDDENException.setMessage(errorContext.Message);
                throw mUTEOTHERSFORBIDDENException;
            }
            case MUTE_OTHERS_INTERNAL_SERVER_ERROR: {
                CallingCommunicationException mUTEOTHERSINTERNALSERVERERRORException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_INTERNAL_SERVER_ERROR, fullMessage);
                mUTEOTHERSINTERNALSERVERERRORException.setCode(errorContext.Code);
                mUTEOTHERSINTERNALSERVERERRORException.setSubCode(errorContext.SubCode);
                mUTEOTHERSINTERNALSERVERERRORException.setMessage(errorContext.Message);
                throw mUTEOTHERSINTERNALSERVERERRORException;
            }
            case MUTE_OTHERS_NOT_FOUND: {
                CallingCommunicationException mUTEOTHERSNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_FOUND, fullMessage);
                mUTEOTHERSNOTFOUNDException.setCode(errorContext.Code);
                mUTEOTHERSNOTFOUNDException.setSubCode(errorContext.SubCode);
                mUTEOTHERSNOTFOUNDException.setMessage(errorContext.Message);
                throw mUTEOTHERSNOTFOUNDException;
            }
            case MUTE_OTHERS_NOT_SUPPORTED: {
                CallingCommunicationException mUTEOTHERSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_SUPPORTED, fullMessage);
                mUTEOTHERSNOTSUPPORTEDException.setCode(errorContext.Code);
                mUTEOTHERSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mUTEOTHERSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mUTEOTHERSNOTSUPPORTEDException;
            }
            case REAL_TIME_TEXT_CONTENT_TOO_LONG: {
                CallingCommunicationException rEALTIMETEXTCONTENTTOOLONGException = new CallingCommunicationException(CallingCommunicationErrors.REAL_TIME_TEXT_CONTENT_TOO_LONG, fullMessage);
                rEALTIMETEXTCONTENTTOOLONGException.setCode(errorContext.Code);
                rEALTIMETEXTCONTENTTOOLONGException.setSubCode(errorContext.SubCode);
                rEALTIMETEXTCONTENTTOOLONGException.setMessage(errorContext.Message);
                throw rEALTIMETEXTCONTENTTOOLONGException;
            }
        }
    }

    static void checkStatus(Status value) {
        if (value == Status.OK) {
            return;
        }
        String fullMessage = "";
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, "", "", "");
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, "", "", "");
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, "", "", "");
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, "", "", "");
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, "", "", "");
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, "", "", "");
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, "", "", "");
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, "", "", "");
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, "", "", "");
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, "", "", "");
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, "", "", "");
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, "", "", "");
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, "", "", "");
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, "", "", "");
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, "", "", "");
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, "", "", "");
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, "", "", "");
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, "", "", "");
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, "", "", "");
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, "", "", "");
            }
            case DUPLICATE_DEVICE_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, "", "", "");
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, "", "", "");
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, "", "", "");
            }
            case INVALID_VIDEO_FORMAT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, "", "", "");
            }
            case INVALID_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, "", "", "");
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, "", "", "");
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, "", "", "");
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, "", "", "");
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, "", "", "");
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, "", "", "");
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, "", "", "");
            }
            case CAPTIONS_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, "", "", "");
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case CAPTIONS_POLICY_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, "", "", "");
            }
            case CAPTIONS_NOT_ACTIVE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, "", "", "");
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, "", "", "");
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, "", "", "");
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, "", "", "");
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, "", "", "");
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, "", "", "");
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, "", "", "");
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, "", "", "");
            }
            case GET_CAPTIONS_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, "", "", "");
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case MAX_SPOTLIGHT_REACHED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, "", "", "");
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, "", "", "");
            }
            case SIGNALING_OPERATION_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, "", "", "");
            }
            case MUSIC_MODE_NOT_ENABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, "", "", "");
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, "", "", "");
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, "", "", "");
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, "", "", "");
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, "", "", "");
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, "", "", "");
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, "", "", "");
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, "", "", "");
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, "", "", "");
            }
            case MEDIA_STATISTICS_INVALID_REPORT_INTERVAL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MEDIA_STATISTICS_INVALID_REPORT_INTERVAL, "", "", "");
            }
            case DATA_CHANNEL_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_FAILED_TO_START, "", "", "");
            }
            case DATA_CHANNEL_SENDER_CLOSED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_SENDER_CLOSED, "", "", "");
            }
            case DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE, "", "", "");
            }
            case DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT, "", "", "");
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH, "", "", "");
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT, "", "", "");
            }
            case INVALID_PARTICIPANT_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PARTICIPANT_ADDED_TO_CALL, "", "", "");
            }
            case INVALID_TOKEN_PROVIDER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_TOKEN_PROVIDER, "", "", "");
            }
            case TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED, "", "", "");
            }
            case CAPTIONS_FAILED_TO_STOP: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_STOP, "", "", "");
            }
            case SWITCH_SOURCE_BLOCKED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SWITCH_SOURCE_BLOCKED, "", "", "");
            }
            case SURVEY_RATING_SCALE_OUT_OF_BOUNDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_OUT_OF_BOUNDS, "", "", "");
            }
            case SURVEY_RATING_SCALE_INVALID_THRESHOLD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_INVALID_THRESHOLD, "", "", "");
            }
            case SURVEY_SCORE_OUT_OF_BOUNDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_SCORE_OUT_OF_BOUNDS, "", "", "");
            }
            case SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED, "", "", "");
            }
            case MUTE_OTHERS_FORBIDDEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_FORBIDDEN, "", "", "");
            }
            case MUTE_OTHERS_INTERNAL_SERVER_ERROR: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_INTERNAL_SERVER_ERROR, "", "", "");
            }
            case MUTE_OTHERS_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_FOUND, "", "", "");
            }
            case MUTE_OTHERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_SUPPORTED, "", "", "");
            }
            case REAL_TIME_TEXT_CONTENT_TOO_LONG: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REAL_TIME_TEXT_CONTENT_TOO_LONG, "", "", "");
            }
        }
    }

    static void checkStatus(long handle, Status value, ErrorInfo errorContext) {
        if (value == Status.OK) {
            return;
        }
        String fullMessage = NativeLibraryHelpers.fullMessageFromErrorContext(errorContext);
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                CallingCommunicationException nONEException = new CallingCommunicationException(CallingCommunicationErrors.NONE, fullMessage);
                nONEException.setCode(errorContext.Code);
                nONEException.setSubCode(errorContext.SubCode);
                nONEException.setMessage(errorContext.Message);
                throw nONEException;
            }
            case NO_AUDIO_PERMISSION: {
                CallingCommunicationException nOAUDIOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, fullMessage);
                nOAUDIOPERMISSIONException.setCode(errorContext.Code);
                nOAUDIOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOAUDIOPERMISSIONException.setMessage(errorContext.Message);
                throw nOAUDIOPERMISSIONException;
            }
            case NO_VIDEO_PERMISSION: {
                CallingCommunicationException nOVIDEOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, fullMessage);
                nOVIDEOPERMISSIONException.setCode(errorContext.Code);
                nOVIDEOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOVIDEOPERMISSIONException.setMessage(errorContext.Message);
                throw nOVIDEOPERMISSIONException;
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                CallingCommunicationException nOAUDIOANDVIDEOPERMISSIONException = new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, fullMessage);
                nOAUDIOANDVIDEOPERMISSIONException.setCode(errorContext.Code);
                nOAUDIOANDVIDEOPERMISSIONException.setSubCode(errorContext.SubCode);
                nOAUDIOANDVIDEOPERMISSIONException.setMessage(errorContext.Message);
                throw nOAUDIOANDVIDEOPERMISSIONException;
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                CallingCommunicationException rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException = new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, fullMessage);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setCode(errorContext.Code);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setSubCode(errorContext.SubCode);
                rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException.setMessage(errorContext.Message);
                throw rECEIVEDINVALIDPUSHNOTIFICATIONPAYLOADException;
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                CallingCommunicationException fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, fullMessage);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setCode(errorContext.Code);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setSubCode(errorContext.SubCode);
                fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException.setMessage(errorContext.Message);
                throw fAILEDTOPROCESSPUSHNOTIFICATIONPAYLOADException;
            }
            case INVALID_GUID_GROUP_ID: {
                CallingCommunicationException iNVALIDGUIDGROUPIDException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, fullMessage);
                iNVALIDGUIDGROUPIDException.setCode(errorContext.Code);
                iNVALIDGUIDGROUPIDException.setSubCode(errorContext.SubCode);
                iNVALIDGUIDGROUPIDException.setMessage(errorContext.Message);
                throw iNVALIDGUIDGROUPIDException;
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                CallingCommunicationException iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, fullMessage);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setCode(errorContext.Code);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setSubCode(errorContext.SubCode);
                iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException.setMessage(errorContext.Message);
                throw iNVALIDPUSHNOTIFICATIONDEVICEREGISTRATIONTOKENException;
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                CallingCommunicationException mULTIPLERENDERERSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, fullMessage);
                mULTIPLERENDERERSNOTSUPPORTEDException.setCode(errorContext.Code);
                mULTIPLERENDERERSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mULTIPLERENDERERSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mULTIPLERENDERERSNOTSUPPORTEDException;
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                CallingCommunicationException mULTIPLEVIEWSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, fullMessage);
                mULTIPLEVIEWSNOTSUPPORTEDException.setCode(errorContext.Code);
                mULTIPLEVIEWSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mULTIPLEVIEWSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mULTIPLEVIEWSNOTSUPPORTEDException;
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                CallingCommunicationException iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, fullMessage);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setCode(errorContext.Code);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setSubCode(errorContext.SubCode);
                iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException.setMessage(errorContext.Message);
                throw iNVALIDLOCALVIDEOSTREAMFORVIDEOOPTIONSException;
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                CallingCommunicationException nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException = new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, fullMessage);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setCode(errorContext.Code);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setSubCode(errorContext.SubCode);
                nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException.setMessage(errorContext.Message);
                throw nOMULTIPLECONNECTIONSWITHSAMEIDENTITYException;
            }
            case INVALID_SERVER_CALL_ID: {
                CallingCommunicationException iNVALIDSERVERCALLIDException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, fullMessage);
                iNVALIDSERVERCALLIDException.setCode(errorContext.Code);
                iNVALIDSERVERCALLIDException.setSubCode(errorContext.SubCode);
                iNVALIDSERVERCALLIDException.setMessage(errorContext.Message);
                throw iNVALIDSERVERCALLIDException;
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                CallingCommunicationException lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, fullMessage);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setCode(errorContext.Code);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setSubCode(errorContext.SubCode);
                lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException.setMessage(errorContext.Message);
                throw lOCALVIDEOSTREAMSWITCHSOURCEFAILUREException;
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                CallingCommunicationException iNCOMINGCALLALREADYUNPLACEDException = new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, fullMessage);
                iNCOMINGCALLALREADYUNPLACEDException.setCode(errorContext.Code);
                iNCOMINGCALLALREADYUNPLACEDException.setSubCode(errorContext.SubCode);
                iNCOMINGCALLALREADYUNPLACEDException.setMessage(errorContext.Message);
                throw iNCOMINGCALLALREADYUNPLACEDException;
            }
            case INVALID_MEETING_LINK: {
                CallingCommunicationException iNVALIDMEETINGLINKException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, fullMessage);
                iNVALIDMEETINGLINKException.setCode(errorContext.Code);
                iNVALIDMEETINGLINKException.setSubCode(errorContext.SubCode);
                iNVALIDMEETINGLINKException.setMessage(errorContext.Message);
                throw iNVALIDMEETINGLINKException;
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                CallingCommunicationException pARTICIPANTADDEDTOUNCONNECTEDCALLException = new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, fullMessage);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setCode(errorContext.Code);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setSubCode(errorContext.SubCode);
                pARTICIPANTADDEDTOUNCONNECTEDCALLException.setMessage(errorContext.Message);
                throw pARTICIPANTADDEDTOUNCONNECTEDCALLException;
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                CallingCommunicationException pARTICIPANTALREADYADDEDTOCALLException = new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, fullMessage);
                pARTICIPANTALREADYADDEDTOCALLException.setCode(errorContext.Code);
                pARTICIPANTALREADYADDEDTOCALLException.setSubCode(errorContext.SubCode);
                pARTICIPANTALREADYADDEDTOCALLException.setMessage(errorContext.Message);
                throw pARTICIPANTALREADYADDEDTOCALLException;
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                CallingCommunicationException cALLFEATUREEXTENSIONNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, fullMessage);
                cALLFEATUREEXTENSIONNOTFOUNDException.setCode(errorContext.Code);
                cALLFEATUREEXTENSIONNOTFOUNDException.setSubCode(errorContext.SubCode);
                cALLFEATUREEXTENSIONNOTFOUNDException.setMessage(errorContext.Message);
                throw cALLFEATUREEXTENSIONNOTFOUNDException;
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                CallingCommunicationException dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, fullMessage);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setCode(errorContext.Code);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setSubCode(errorContext.SubCode);
                dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException.setMessage(errorContext.Message);
                throw dISPLAYNAMELENGTHLONGERTHANSUPPORTEDException;
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                CallingCommunicationException fAILEDTOHANGUPFOREVERYONEException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, fullMessage);
                fAILEDTOHANGUPFOREVERYONEException.setCode(errorContext.Code);
                fAILEDTOHANGUPFOREVERYONEException.setSubCode(errorContext.SubCode);
                fAILEDTOHANGUPFOREVERYONEException.setMessage(errorContext.Message);
                throw fAILEDTOHANGUPFOREVERYONEException;
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                CallingCommunicationException nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException = new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, fullMessage);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setCode(errorContext.Code);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setSubCode(errorContext.SubCode);
                nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException.setMessage(errorContext.Message);
                throw nOMULTIPLECONNECTIONSWITHDIFFERENTCLOUDSException;
            }
            case DUPLICATE_DEVICE_ID: {
                CallingCommunicationException dUPLICATEDEVICEIDException = new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, fullMessage);
                dUPLICATEDEVICEIDException.setCode(errorContext.Code);
                dUPLICATEDEVICEIDException.setSubCode(errorContext.SubCode);
                dUPLICATEDEVICEIDException.setMessage(errorContext.Message);
                throw dUPLICATEDEVICEIDException;
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                CallingCommunicationException vIRTUALDEVICENOTSTARTEDException = new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, fullMessage);
                vIRTUALDEVICENOTSTARTEDException.setCode(errorContext.Code);
                vIRTUALDEVICENOTSTARTEDException.setSubCode(errorContext.SubCode);
                vIRTUALDEVICENOTSTARTEDException.setMessage(errorContext.Message);
                throw vIRTUALDEVICENOTSTARTEDException;
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                CallingCommunicationException iNVALIDVIDEOSTREAMCOMBINATIONException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, fullMessage);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setCode(errorContext.Code);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setSubCode(errorContext.SubCode);
                iNVALIDVIDEOSTREAMCOMBINATIONException.setMessage(errorContext.Message);
                throw iNVALIDVIDEOSTREAMCOMBINATIONException;
            }
            case INVALID_VIDEO_FORMAT: {
                CallingCommunicationException iNVALIDVIDEOFORMATException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, fullMessage);
                iNVALIDVIDEOFORMATException.setCode(errorContext.Code);
                iNVALIDVIDEOFORMATException.setSubCode(errorContext.SubCode);
                iNVALIDVIDEOFORMATException.setMessage(errorContext.Message);
                throw iNVALIDVIDEOFORMATException;
            }
            case INVALID_BUFFER: {
                CallingCommunicationException iNVALIDBUFFERException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, fullMessage);
                iNVALIDBUFFERException.setCode(errorContext.Code);
                iNVALIDBUFFERException.setSubCode(errorContext.SubCode);
                iNVALIDBUFFERException.setMessage(errorContext.Message);
                throw iNVALIDBUFFERException;
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                CallingCommunicationException rAWVIDEOFRAMENOTSENTException = new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, fullMessage);
                rAWVIDEOFRAMENOTSENTException.setCode(errorContext.Code);
                rAWVIDEOFRAMENOTSENTException.setSubCode(errorContext.SubCode);
                rAWVIDEOFRAMENOTSENTException.setMessage(errorContext.Message);
                throw rAWVIDEOFRAMENOTSENTException;
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                CallingCommunicationException uNSUPPORTEDVIDEOSTREAMRESOLUTIONException = new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, fullMessage);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setCode(errorContext.Code);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setSubCode(errorContext.SubCode);
                uNSUPPORTEDVIDEOSTREAMRESOLUTIONException.setMessage(errorContext.Message);
                throw uNSUPPORTEDVIDEOSTREAMRESOLUTIONException;
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                CallingCommunicationException fEATUREEXTENSIONNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, fullMessage);
                fEATUREEXTENSIONNOTFOUNDException.setCode(errorContext.Code);
                fEATUREEXTENSIONNOTFOUNDException.setSubCode(errorContext.SubCode);
                fEATUREEXTENSIONNOTFOUNDException.setMessage(errorContext.Message);
                throw fEATUREEXTENSIONNOTFOUNDException;
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                CallingCommunicationException vIDEOEFFECTNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, fullMessage);
                vIDEOEFFECTNOTSUPPORTEDException.setCode(errorContext.Code);
                vIDEOEFFECTNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                vIDEOEFFECTNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw vIDEOEFFECTNOTSUPPORTEDException;
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                CallingCommunicationException fAILEDTOSENDRAWAUDIOBUFFERException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, fullMessage);
                fAILEDTOSENDRAWAUDIOBUFFERException.setCode(errorContext.Code);
                fAILEDTOSENDRAWAUDIOBUFFERException.setSubCode(errorContext.SubCode);
                fAILEDTOSENDRAWAUDIOBUFFERException.setMessage(errorContext.Message);
                throw fAILEDTOSENDRAWAUDIOBUFFERException;
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                CallingCommunicationException cANNOTMUTEVIRTUALAUDIOSTREAMException = new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, fullMessage);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setCode(errorContext.Code);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setSubCode(errorContext.SubCode);
                cANNOTMUTEVIRTUALAUDIOSTREAMException.setMessage(errorContext.Message);
                throw cANNOTMUTEVIRTUALAUDIOSTREAMException;
            }
            case CAPTIONS_FAILED_TO_START: {
                CallingCommunicationException cAPTIONSFAILEDTOSTARTException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, fullMessage);
                cAPTIONSFAILEDTOSTARTException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSTARTException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSTARTException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSTARTException;
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException cAPTIONSDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, fullMessage);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                cAPTIONSDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw cAPTIONSDISABLEDBYCONFIGURATIONSException;
            }
            case CAPTIONS_POLICY_DISABLED: {
                CallingCommunicationException cAPTIONSPOLICYDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, fullMessage);
                cAPTIONSPOLICYDISABLEDException.setCode(errorContext.Code);
                cAPTIONSPOLICYDISABLEDException.setSubCode(errorContext.SubCode);
                cAPTIONSPOLICYDISABLEDException.setMessage(errorContext.Message);
                throw cAPTIONSPOLICYDISABLEDException;
            }
            case CAPTIONS_NOT_ACTIVE: {
                CallingCommunicationException cAPTIONSNOTACTIVEException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, fullMessage);
                cAPTIONSNOTACTIVEException.setCode(errorContext.Code);
                cAPTIONSNOTACTIVEException.setSubCode(errorContext.SubCode);
                cAPTIONSNOTACTIVEException.setMessage(errorContext.Message);
                throw cAPTIONSNOTACTIVEException;
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                CallingCommunicationException cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, fullMessage);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setCode(errorContext.Code);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException.setMessage(errorContext.Message);
                throw cAPTIONSREQUESTEDLANGUAGENOTSUPPORTEDException;
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                CallingCommunicationException fAILEDTOSETCAPTIONLANGUAGEException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, fullMessage);
                fAILEDTOSETCAPTIONLANGUAGEException.setCode(errorContext.Code);
                fAILEDTOSETCAPTIONLANGUAGEException.setSubCode(errorContext.SubCode);
                fAILEDTOSETCAPTIONLANGUAGEException.setMessage(errorContext.Message);
                throw fAILEDTOSETCAPTIONLANGUAGEException;
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                CallingCommunicationException sETCAPTIONLANGUAGEDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, fullMessage);
                sETCAPTIONLANGUAGEDISABLEDException.setCode(errorContext.Code);
                sETCAPTIONLANGUAGEDISABLEDException.setSubCode(errorContext.SubCode);
                sETCAPTIONLANGUAGEDISABLEDException.setMessage(errorContext.Message);
                throw sETCAPTIONLANGUAGEDISABLEDException;
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                CallingCommunicationException sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException = new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, fullMessage);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setCode(errorContext.Code);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setSubCode(errorContext.SubCode);
                sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException.setMessage(errorContext.Message);
                throw sETCAPTIONLANGUAGETEAMSPREMIUMLICENSENEEDEDException;
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                CallingCommunicationException cAPTIONSFAILEDTOSETSPOKENLANGUAGEException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, fullMessage);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSETSPOKENLANGUAGEException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSETSPOKENLANGUAGEException;
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                CallingCommunicationException cAPTIONSSETSPOKENLANGUAGEDISABLEDException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, fullMessage);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setCode(errorContext.Code);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setSubCode(errorContext.SubCode);
                cAPTIONSSETSPOKENLANGUAGEDISABLEDException.setMessage(errorContext.Message);
                throw cAPTIONSSETSPOKENLANGUAGEDISABLEDException;
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                CallingCommunicationException gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException = new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, fullMessage);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setCode(errorContext.Code);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setSubCode(errorContext.SubCode);
                gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException.setMessage(errorContext.Message);
                throw gETCAPTIONSFAILEDCALLSTATENOTCONNECTEDException;
            }
            case GET_CAPTIONS_FAILED: {
                CallingCommunicationException gETCAPTIONSFAILEDException = new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, fullMessage);
                gETCAPTIONSFAILEDException.setCode(errorContext.Code);
                gETCAPTIONSFAILEDException.setSubCode(errorContext.SubCode);
                gETCAPTIONSFAILEDException.setMessage(errorContext.Message);
                throw gETCAPTIONSFAILEDException;
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException sPOTLIGHTDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, fullMessage);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                sPOTLIGHTDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw sPOTLIGHTDISABLEDBYCONFIGURATIONSException;
            }
            case MAX_SPOTLIGHT_REACHED: {
                CallingCommunicationException mAXSPOTLIGHTREACHEDException = new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, fullMessage);
                mAXSPOTLIGHTREACHEDException.setCode(errorContext.Code);
                mAXSPOTLIGHTREACHEDException.setSubCode(errorContext.SubCode);
                mAXSPOTLIGHTREACHEDException.setMessage(errorContext.Message);
                throw mAXSPOTLIGHTREACHEDException;
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                CallingCommunicationException sPOTLIGHTPARTICIPANTEMPTYLISTException = new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, fullMessage);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setCode(errorContext.Code);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setSubCode(errorContext.SubCode);
                sPOTLIGHTPARTICIPANTEMPTYLISTException.setMessage(errorContext.Message);
                throw sPOTLIGHTPARTICIPANTEMPTYLISTException;
            }
            case SIGNALING_OPERATION_FAILED: {
                CallingCommunicationException sIGNALINGOPERATIONFAILEDException = new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, fullMessage);
                sIGNALINGOPERATIONFAILEDException.setCode(errorContext.Code);
                sIGNALINGOPERATIONFAILEDException.setSubCode(errorContext.SubCode);
                sIGNALINGOPERATIONFAILEDException.setMessage(errorContext.Message);
                throw sIGNALINGOPERATIONFAILEDException;
            }
            case MUSIC_MODE_NOT_ENABLED: {
                CallingCommunicationException mUSICMODENOTENABLEDException = new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, fullMessage);
                mUSICMODENOTENABLEDException.setCode(errorContext.Code);
                mUSICMODENOTENABLEDException.setSubCode(errorContext.SubCode);
                mUSICMODENOTENABLEDException.setMessage(errorContext.Message);
                throw mUSICMODENOTENABLEDException;
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                CallingCommunicationException lOBBYDISABLEDBYCONFIGURATIONSException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, fullMessage);
                lOBBYDISABLEDBYCONFIGURATIONSException.setCode(errorContext.Code);
                lOBBYDISABLEDBYCONFIGURATIONSException.setSubCode(errorContext.SubCode);
                lOBBYDISABLEDBYCONFIGURATIONSException.setMessage(errorContext.Message);
                throw lOBBYDISABLEDBYCONFIGURATIONSException;
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                CallingCommunicationException lOBBYCONVERSATIONTYPENOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, fullMessage);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setCode(errorContext.Code);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                lOBBYCONVERSATIONTYPENOTSUPPORTEDException.setMessage(errorContext.Message);
                throw lOBBYCONVERSATIONTYPENOTSUPPORTEDException;
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                CallingCommunicationException lOBBYMEETINGROLENOTALLOWEDException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, fullMessage);
                lOBBYMEETINGROLENOTALLOWEDException.setCode(errorContext.Code);
                lOBBYMEETINGROLENOTALLOWEDException.setSubCode(errorContext.SubCode);
                lOBBYMEETINGROLENOTALLOWEDException.setMessage(errorContext.Message);
                throw lOBBYMEETINGROLENOTALLOWEDException;
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                CallingCommunicationException lOBBYPARTICIPANTNOTEXISTException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, fullMessage);
                lOBBYPARTICIPANTNOTEXISTException.setCode(errorContext.Code);
                lOBBYPARTICIPANTNOTEXISTException.setSubCode(errorContext.SubCode);
                lOBBYPARTICIPANTNOTEXISTException.setMessage(errorContext.Message);
                throw lOBBYPARTICIPANTNOTEXISTException;
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                CallingCommunicationException rEMOVEPARTICIPANTOPERATIONFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, fullMessage);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setCode(errorContext.Code);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setSubCode(errorContext.SubCode);
                rEMOVEPARTICIPANTOPERATIONFAILUREException.setMessage(errorContext.Message);
                throw rEMOVEPARTICIPANTOPERATIONFAILUREException;
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                CallingCommunicationException lOBBYADMITOPERATIONFAILUREException = new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, fullMessage);
                lOBBYADMITOPERATIONFAILUREException.setCode(errorContext.Code);
                lOBBYADMITOPERATIONFAILUREException.setSubCode(errorContext.SubCode);
                lOBBYADMITOPERATIONFAILUREException.setMessage(errorContext.Message);
                throw lOBBYADMITOPERATIONFAILUREException;
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                CallingCommunicationException pROXYNOTAVAILABLEFORTEAMSException = new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, fullMessage);
                pROXYNOTAVAILABLEFORTEAMSException.setCode(errorContext.Code);
                pROXYNOTAVAILABLEFORTEAMSException.setSubCode(errorContext.SubCode);
                pROXYNOTAVAILABLEFORTEAMSException.setMessage(errorContext.Message);
                throw pROXYNOTAVAILABLEFORTEAMSException;
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                CallingCommunicationException fAILEDTOSETMEDIAPROXYException = new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, fullMessage);
                fAILEDTOSETMEDIAPROXYException.setCode(errorContext.Code);
                fAILEDTOSETMEDIAPROXYException.setSubCode(errorContext.SubCode);
                fAILEDTOSETMEDIAPROXYException.setMessage(errorContext.Message);
                throw fAILEDTOSETMEDIAPROXYException;
            }
            case MEDIA_STATISTICS_INVALID_REPORT_INTERVAL: {
                CallingCommunicationException mEDIASTATISTICSINVALIDREPORTINTERVALException = new CallingCommunicationException(CallingCommunicationErrors.MEDIA_STATISTICS_INVALID_REPORT_INTERVAL, fullMessage);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setCode(errorContext.Code);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setSubCode(errorContext.SubCode);
                mEDIASTATISTICSINVALIDREPORTINTERVALException.setMessage(errorContext.Message);
                throw mEDIASTATISTICSINVALIDREPORTINTERVALException;
            }
            case DATA_CHANNEL_FAILED_TO_START: {
                CallingCommunicationException dATACHANNELFAILEDTOSTARTException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_FAILED_TO_START, fullMessage);
                dATACHANNELFAILEDTOSTARTException.setCode(errorContext.Code);
                dATACHANNELFAILEDTOSTARTException.setSubCode(errorContext.SubCode);
                dATACHANNELFAILEDTOSTARTException.setMessage(errorContext.Message);
                throw dATACHANNELFAILEDTOSTARTException;
            }
            case DATA_CHANNEL_SENDER_CLOSED: {
                CallingCommunicationException dATACHANNELSENDERCLOSEDException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_SENDER_CLOSED, fullMessage);
                dATACHANNELSENDERCLOSEDException.setCode(errorContext.Code);
                dATACHANNELSENDERCLOSEDException.setSubCode(errorContext.SubCode);
                dATACHANNELSENDERCLOSEDException.setMessage(errorContext.Message);
                throw dATACHANNELSENDERCLOSEDException;
            }
            case DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE: {
                CallingCommunicationException dATACHANNELRANDOMIDNOTAVAILABLEException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE, fullMessage);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setCode(errorContext.Code);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setSubCode(errorContext.SubCode);
                dATACHANNELRANDOMIDNOTAVAILABLEException.setMessage(errorContext.Message);
                throw dATACHANNELRANDOMIDNOTAVAILABLEException;
            }
            case DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT: {
                CallingCommunicationException dATACHANNELMESSAGESIZEOVERLIMITException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT, fullMessage);
                dATACHANNELMESSAGESIZEOVERLIMITException.setCode(errorContext.Code);
                dATACHANNELMESSAGESIZEOVERLIMITException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGESIZEOVERLIMITException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGESIZEOVERLIMITException;
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH: {
                CallingCommunicationException dATACHANNELMESSAGEFAILUREFORBANDWIDTHException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH, fullMessage);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setCode(errorContext.Code);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGEFAILUREFORBANDWIDTHException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGEFAILUREFORBANDWIDTHException;
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT: {
                CallingCommunicationException dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException = new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT, fullMessage);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setCode(errorContext.Code);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setSubCode(errorContext.SubCode);
                dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException.setMessage(errorContext.Message);
                throw dATACHANNELMESSAGEFAILUREFORTRAFFICLIMITException;
            }
            case INVALID_PARTICIPANT_ADDED_TO_CALL: {
                CallingCommunicationException iNVALIDPARTICIPANTADDEDTOCALLException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_PARTICIPANT_ADDED_TO_CALL, fullMessage);
                iNVALIDPARTICIPANTADDEDTOCALLException.setCode(errorContext.Code);
                iNVALIDPARTICIPANTADDEDTOCALLException.setSubCode(errorContext.SubCode);
                iNVALIDPARTICIPANTADDEDTOCALLException.setMessage(errorContext.Message);
                throw iNVALIDPARTICIPANTADDEDTOCALLException;
            }
            case INVALID_TOKEN_PROVIDER: {
                CallingCommunicationException iNVALIDTOKENPROVIDERException = new CallingCommunicationException(CallingCommunicationErrors.INVALID_TOKEN_PROVIDER, fullMessage);
                iNVALIDTOKENPROVIDERException.setCode(errorContext.Code);
                iNVALIDTOKENPROVIDERException.setSubCode(errorContext.SubCode);
                iNVALIDTOKENPROVIDERException.setMessage(errorContext.Message);
                throw iNVALIDTOKENPROVIDERException;
            }
            case TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED: {
                CallingCommunicationException tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED, fullMessage);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setCode(errorContext.Code);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw tEAMSFORLIFEMEETINGJOINNOTSUPPORTEDException;
            }
            case CAPTIONS_FAILED_TO_STOP: {
                CallingCommunicationException cAPTIONSFAILEDTOSTOPException = new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_STOP, fullMessage);
                cAPTIONSFAILEDTOSTOPException.setCode(errorContext.Code);
                cAPTIONSFAILEDTOSTOPException.setSubCode(errorContext.SubCode);
                cAPTIONSFAILEDTOSTOPException.setMessage(errorContext.Message);
                throw cAPTIONSFAILEDTOSTOPException;
            }
            case SWITCH_SOURCE_BLOCKED: {
                CallingCommunicationException sWITCHSOURCEBLOCKEDException = new CallingCommunicationException(CallingCommunicationErrors.SWITCH_SOURCE_BLOCKED, fullMessage);
                sWITCHSOURCEBLOCKEDException.setCode(errorContext.Code);
                sWITCHSOURCEBLOCKEDException.setSubCode(errorContext.SubCode);
                sWITCHSOURCEBLOCKEDException.setMessage(errorContext.Message);
                throw sWITCHSOURCEBLOCKEDException;
            }
            case SURVEY_RATING_SCALE_OUT_OF_BOUNDS: {
                CallingCommunicationException sURVEYRATINGSCALEOUTOFBOUNDSException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_OUT_OF_BOUNDS, fullMessage);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setCode(errorContext.Code);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setSubCode(errorContext.SubCode);
                sURVEYRATINGSCALEOUTOFBOUNDSException.setMessage(errorContext.Message);
                throw sURVEYRATINGSCALEOUTOFBOUNDSException;
            }
            case SURVEY_RATING_SCALE_INVALID_THRESHOLD: {
                CallingCommunicationException sURVEYRATINGSCALEINVALIDTHRESHOLDException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_INVALID_THRESHOLD, fullMessage);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setCode(errorContext.Code);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setSubCode(errorContext.SubCode);
                sURVEYRATINGSCALEINVALIDTHRESHOLDException.setMessage(errorContext.Message);
                throw sURVEYRATINGSCALEINVALIDTHRESHOLDException;
            }
            case SURVEY_SCORE_OUT_OF_BOUNDS: {
                CallingCommunicationException sURVEYSCOREOUTOFBOUNDSException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_SCORE_OUT_OF_BOUNDS, fullMessage);
                sURVEYSCOREOUTOFBOUNDSException.setCode(errorContext.Code);
                sURVEYSCOREOUTOFBOUNDSException.setSubCode(errorContext.SubCode);
                sURVEYSCOREOUTOFBOUNDSException.setMessage(errorContext.Message);
                throw sURVEYSCOREOUTOFBOUNDSException;
            }
            case SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED: {
                CallingCommunicationException sURVEYDOUBLESUBMISSIONNOTALLOWEDException = new CallingCommunicationException(CallingCommunicationErrors.SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED, fullMessage);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setCode(errorContext.Code);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setSubCode(errorContext.SubCode);
                sURVEYDOUBLESUBMISSIONNOTALLOWEDException.setMessage(errorContext.Message);
                throw sURVEYDOUBLESUBMISSIONNOTALLOWEDException;
            }
            case MUTE_OTHERS_FORBIDDEN: {
                CallingCommunicationException mUTEOTHERSFORBIDDENException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_FORBIDDEN, fullMessage);
                mUTEOTHERSFORBIDDENException.setCode(errorContext.Code);
                mUTEOTHERSFORBIDDENException.setSubCode(errorContext.SubCode);
                mUTEOTHERSFORBIDDENException.setMessage(errorContext.Message);
                throw mUTEOTHERSFORBIDDENException;
            }
            case MUTE_OTHERS_INTERNAL_SERVER_ERROR: {
                CallingCommunicationException mUTEOTHERSINTERNALSERVERERRORException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_INTERNAL_SERVER_ERROR, fullMessage);
                mUTEOTHERSINTERNALSERVERERRORException.setCode(errorContext.Code);
                mUTEOTHERSINTERNALSERVERERRORException.setSubCode(errorContext.SubCode);
                mUTEOTHERSINTERNALSERVERERRORException.setMessage(errorContext.Message);
                throw mUTEOTHERSINTERNALSERVERERRORException;
            }
            case MUTE_OTHERS_NOT_FOUND: {
                CallingCommunicationException mUTEOTHERSNOTFOUNDException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_FOUND, fullMessage);
                mUTEOTHERSNOTFOUNDException.setCode(errorContext.Code);
                mUTEOTHERSNOTFOUNDException.setSubCode(errorContext.SubCode);
                mUTEOTHERSNOTFOUNDException.setMessage(errorContext.Message);
                throw mUTEOTHERSNOTFOUNDException;
            }
            case MUTE_OTHERS_NOT_SUPPORTED: {
                CallingCommunicationException mUTEOTHERSNOTSUPPORTEDException = new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_SUPPORTED, fullMessage);
                mUTEOTHERSNOTSUPPORTEDException.setCode(errorContext.Code);
                mUTEOTHERSNOTSUPPORTEDException.setSubCode(errorContext.SubCode);
                mUTEOTHERSNOTSUPPORTEDException.setMessage(errorContext.Message);
                throw mUTEOTHERSNOTSUPPORTEDException;
            }
            case REAL_TIME_TEXT_CONTENT_TOO_LONG: {
                CallingCommunicationException rEALTIMETEXTCONTENTTOOLONGException = new CallingCommunicationException(CallingCommunicationErrors.REAL_TIME_TEXT_CONTENT_TOO_LONG, fullMessage);
                rEALTIMETEXTCONTENTTOOLONGException.setCode(errorContext.Code);
                rEALTIMETEXTCONTENTTOOLONGException.setSubCode(errorContext.SubCode);
                rEALTIMETEXTCONTENTTOOLONGException.setMessage(errorContext.Message);
                throw rEALTIMETEXTCONTENTTOOLONGException;
            }
        }
    }

    static void checkStatus(long handle, Status value) {
        String fullMessage;
        if (value == Status.OK) {
            return;
        }
        Out<String> outParam_message = new Out<String>();
        Out<String> outParam_requestCorrelationVector = new Out<String>();
        Out<String> outParam_responseCorrelationVector = new Out<String>();
        Status code = NativeLibrary.sam_get_error_details(handle, outParam_message, outParam_requestCorrelationVector, outParam_responseCorrelationVector);
        if (code == Status.FAILED) {
            throw new IllegalStateException("Unexpected error in exception handling.");
        }
        if (code != Status.OK) {
            fullMessage = "Exception thrown and an unexpected error in exception handling.";
        } else {
            fullMessage = (String)outParam_message.value + ".";
            if (outParam_requestCorrelationVector.value != null && !((String)outParam_requestCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Request CV: " + (String)outParam_requestCorrelationVector.value + ".";
            }
            if (outParam_responseCorrelationVector.value != null && !((String)outParam_responseCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Response CV: " + (String)outParam_responseCorrelationVector.value + ".";
            }
        }
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case CONCURRENT_MUTATION: {
                throw new IllegalStateException("ConcurrentMutation: " + fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case OPERATION_CANCELED: {
                throw new CancellationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DISPLAY_NAME_LENGTH_LONGER_THAN_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_HANGUP_FOR_EVERYONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_HANGUP_FOR_EVERYONE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_DIFFERENT_CLOUDS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DUPLICATE_DEVICE_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DUPLICATE_DEVICE_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case VIRTUAL_DEVICE_NOT_STARTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIRTUAL_DEVICE_NOT_STARTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_VIDEO_STREAM_COMBINATION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_STREAM_COMBINATION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_VIDEO_FORMAT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_VIDEO_FORMAT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_BUFFER, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case RAW_VIDEO_FRAME_NOT_SENT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RAW_VIDEO_FRAME_NOT_SENT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case UNSUPPORTED_VIDEO_STREAM_RESOLUTION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.UNSUPPORTED_VIDEO_STREAM_RESOLUTION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FEATURE_EXTENSION_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case VIDEO_EFFECT_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.VIDEO_EFFECT_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SEND_RAW_AUDIO_BUFFER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SEND_RAW_AUDIO_BUFFER, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CANNOT_MUTE_VIRTUAL_AUDIO_STREAM: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CANNOT_MUTE_VIRTUAL_AUDIO_STREAM, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_START, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_POLICY_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_POLICY_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_NOT_ACTIVE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_NOT_ACTIVE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_REQUESTED_LANGUAGE_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SET_CAPTION_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_CAPTION_LANGUAGE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SET_CAPTION_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SET_CAPTION_LANGUAGE_TEAMS_PREMIUM_LICENSE_NEEDED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_SET_SPOKEN_LANGUAGE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_SET_SPOKEN_LANGUAGE_DISABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED_CALL_STATE_NOT_CONNECTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case GET_CAPTIONS_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.GET_CAPTIONS_FAILED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SPOTLIGHT_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MAX_SPOTLIGHT_REACHED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MAX_SPOTLIGHT_REACHED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SPOTLIGHT_PARTICIPANT_EMPTY_LIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SPOTLIGHT_PARTICIPANT_EMPTY_LIST, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SIGNALING_OPERATION_FAILED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SIGNALING_OPERATION_FAILED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUSIC_MODE_NOT_ENABLED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUSIC_MODE_NOT_ENABLED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_DISABLED_BY_CONFIGURATIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_DISABLED_BY_CONFIGURATIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_CONVERSATION_TYPE_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_MEETING_ROLE_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_MEETING_ROLE_NOT_ALLOWED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_PARTICIPANT_NOT_EXIST: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_PARTICIPANT_NOT_EXIST, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case REMOVE_PARTICIPANT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REMOVE_PARTICIPANT_OPERATION_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOBBY_ADMIT_OPERATION_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOBBY_ADMIT_OPERATION_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PROXY_NOT_AVAILABLE_FOR_TEAMS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PROXY_NOT_AVAILABLE_FOR_TEAMS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_SET_MEDIA_PROXY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_SET_MEDIA_PROXY, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MEDIA_STATISTICS_INVALID_REPORT_INTERVAL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MEDIA_STATISTICS_INVALID_REPORT_INTERVAL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_FAILED_TO_START: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_FAILED_TO_START, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_SENDER_CLOSED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_SENDER_CLOSED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_RANDOM_ID_NOT_AVAILABLE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_SIZE_OVER_LIMIT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_BANDWIDTH, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT: {
                throw new CallingCommunicationException(CallingCommunicationErrors.DATA_CHANNEL_MESSAGE_FAILURE_FOR_TRAFFIC_LIMIT, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_PARTICIPANT_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PARTICIPANT_ADDED_TO_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_TOKEN_PROVIDER: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_TOKEN_PROVIDER, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.TEAMS_FOR_LIFE_MEETING_JOIN_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CAPTIONS_FAILED_TO_STOP: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CAPTIONS_FAILED_TO_STOP, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SWITCH_SOURCE_BLOCKED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SWITCH_SOURCE_BLOCKED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SURVEY_RATING_SCALE_OUT_OF_BOUNDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_OUT_OF_BOUNDS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SURVEY_RATING_SCALE_INVALID_THRESHOLD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_RATING_SCALE_INVALID_THRESHOLD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SURVEY_SCORE_OUT_OF_BOUNDS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_SCORE_OUT_OF_BOUNDS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.SURVEY_DOUBLE_SUBMISSION_NOT_ALLOWED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUTE_OTHERS_FORBIDDEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_FORBIDDEN, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUTE_OTHERS_INTERNAL_SERVER_ERROR: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_INTERNAL_SERVER_ERROR, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUTE_OTHERS_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MUTE_OTHERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MUTE_OTHERS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case REAL_TIME_TEXT_CONTENT_TOO_LONG: {
                throw new CallingCommunicationException(CallingCommunicationErrors.REAL_TIME_TEXT_CONTENT_TOO_LONG, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
        }
    }
}

