/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class OutgoingVideoConstraints {
    long handle;

    OutgoingVideoConstraints(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_video_constraints_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public OutgoingVideoConstraints() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_outgoing_video_constraints_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_release(this.handle));
        this.handle = 0L;
    }

    private int getMaxHeightInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_get_max_height_internal(this.handle, result));
        return (Integer)result.value;
    }

    private OutgoingVideoConstraints setMaxHeightInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_set_max_height_internal(this.handle, value));
        return this;
    }

    private int getMaxWidthInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_get_max_width_internal(this.handle, result));
        return (Integer)result.value;
    }

    private OutgoingVideoConstraints setMaxWidthInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_set_max_width_internal(this.handle, value));
        return this;
    }

    private int getMaxFrameRateInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_get_max_frame_rate_internal(this.handle, result));
        return (Integer)result.value;
    }

    private OutgoingVideoConstraints setMaxFrameRateInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_set_max_frame_rate_internal(this.handle, value));
        return this;
    }

    private int getMaxBitRateInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_get_max_bit_rate_internal(this.handle, result));
        return (Integer)result.value;
    }

    private OutgoingVideoConstraints setMaxBitRateInternal(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_constraints_set_max_bit_rate_internal(this.handle, value));
        return this;
    }

    static OutgoingVideoConstraints getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoConstraints, OutgoingVideoConstraints.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_video_constraints_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoConstraints, OutgoingVideoConstraints.class, false);
    }

    public Integer getMaxHeight() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getMaxHeightInternal());
    }

    public OutgoingVideoConstraints setMaxHeight(Integer value) {
        this.setMaxHeightInternal(value);
        return this;
    }

    public Integer getMaxWidth() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getMaxWidthInternal());
    }

    public OutgoingVideoConstraints setMaxWidth(Integer value) {
        this.setMaxWidthInternal(value);
        return this;
    }

    public Integer getMaxFrameRate() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getMaxFrameRateInternal());
    }

    public OutgoingVideoConstraints setMaxFrameRate(Integer value) {
        this.setMaxFrameRateInternal(value);
        return this;
    }

    public Integer getMaxBitrateInBps() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getMaxBitRateInternal());
    }

    public OutgoingVideoConstraints setMaxBitrateInBps(Integer value) {
        this.setMaxBitRateInternal(value);
        return this;
    }
}

