/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingVideoConstraints;
import com.azure.android.communication.calling.OutgoingVideoStream;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OutgoingVideoOptions {
    long handle;

    OutgoingVideoOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_outgoing_video_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public OutgoingVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_outgoing_video_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_options_release(this.handle));
        this.handle = 0L;
    }

    public List<OutgoingVideoStream> getStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_options_get_streams(this.handle, result, result_length));
        ArrayList<OutgoingVideoStream> resultList = new ArrayList<OutgoingVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(Factories.OutgoingVideoStreamFactory(resultArray[i], true));
        }
        List<OutgoingVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public OutgoingVideoConstraints getConstraints() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_options_get_constraints(this.handle, result_handle));
        OutgoingVideoConstraints result_object = (Long)result_handle.value != 0L ? OutgoingVideoConstraints.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public OutgoingVideoOptions setConstraints(OutgoingVideoConstraints value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_options_set_constraints(this.handle, value_converted));
        return this;
    }

    private void setOutgoingVideoStreamsInternal(OutgoingVideoStream[] outgoingVideoStreams) {
        long[] outgoingVideoStreams_converted = new long[outgoingVideoStreams.length];
        for (int i = 0; i < outgoingVideoStreams.length; ++i) {
            outgoingVideoStreams_converted[i] = outgoingVideoStreams[i].handle;
        }
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_outgoing_video_options_set_outgoing_video_streams_internal(this.handle, outgoingVideoStreams_converted, outgoingVideoStreams.length));
    }

    static OutgoingVideoOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoOptions, OutgoingVideoOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_outgoing_video_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.OutgoingVideoOptions, OutgoingVideoOptions.class, false);
    }

    public OutgoingVideoOptions setOutgoingVideoStreams(Iterable<OutgoingVideoStream> outgoingVideoStreams) {
        ArrayList<OutgoingVideoStream> outgoingVideoStreamList = new ArrayList<OutgoingVideoStream>();
        for (OutgoingVideoStream outgoingVideoStream : outgoingVideoStreams) {
            outgoingVideoStreamList.add(outgoingVideoStream);
        }
        OutgoingVideoStream[] outgoingVideoStreamArray = new OutgoingVideoStream[outgoingVideoStreamList.size()];
        this.setOutgoingVideoStreamsInternal(outgoingVideoStreamList.toArray(outgoingVideoStreamArray));
        return this;
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

