/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CapabilityResolutionReason;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantCapabilityType;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class ParticipantCapability {
    long handle;

    ParticipantCapability(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_participant_capability_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participant_capability_release(this.handle));
        this.handle = 0L;
    }

    public ParticipantCapabilityType getType() {
        Out<ParticipantCapabilityType> result = new Out<ParticipantCapabilityType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participant_capability_get_type(this.handle, result));
        return (ParticipantCapabilityType)((Object)result.value);
    }

    public boolean isAllowed() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participant_capability_get_is_allowed(this.handle, result));
        return (Boolean)result.value;
    }

    public CapabilityResolutionReason getReason() {
        Out<CapabilityResolutionReason> result = new Out<CapabilityResolutionReason>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participant_capability_get_reason(this.handle, result));
        return (CapabilityResolutionReason)((Object)result.value);
    }

    static ParticipantCapability getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ParticipantCapability, ParticipantCapability.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_participant_capability_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ParticipantCapability, ParticipantCapability.class, false);
    }
}

