/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.LoweredHandChangedEvent;
import com.azure.android.communication.calling.LoweredHandListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RaisedHand;
import com.azure.android.communication.calling.RaisedHandChangedEvent;
import com.azure.android.communication.calling.RaisedHandListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class RaiseHandCallFeature
extends CallFeature {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<RaisedHandListener> OnHandRaisedListeners = new CopyOnWriteArrayList<RaisedHandListener>();
    private List<LoweredHandListener> OnHandLoweredListeners = new CopyOnWriteArrayList<LoweredHandListener>();

    RaiseHandCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RaiseHandCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public List<RaisedHand> getRaisedHands() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raise_hand_call_feature_get_raised_hands(this.handle, result, result_length));
        ArrayList<RaisedHand> resultList = new ArrayList<RaisedHand>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(RaisedHand.getInstance(resultArray[i], true));
        }
        List<RaisedHand> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnHandRaisedStaticHandler(long cookie, long args) {
        RaiseHandCallFeature instance = RaiseHandCallFeature.getInstance(cookie);
        if (instance != null) {
            RaisedHandChangedEvent args_converted = args != 0L ? RaisedHandChangedEvent.getInstance(args, false) : null;
            for (RaisedHandListener listener : instance.OnHandRaisedListeners) {
                listener.onRaisedHand(args_converted);
            }
        }
    }

    public void addOnHandRaisedListener(RaisedHandListener listener) {
        this.OnHandRaisedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnHandRaised", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raise_hand_call_feature_set_on_hand_raised(this.handle, this.getHandle(), this));
    }

    public void removeOnHandRaisedListener(RaisedHandListener listener) {
        this.OnHandRaisedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnHandRaised", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raise_hand_call_feature_set_on_hand_raised(this.handle, 0L, null));
        }
    }

    private static void OnHandLoweredStaticHandler(long cookie, long args) {
        RaiseHandCallFeature instance = RaiseHandCallFeature.getInstance(cookie);
        if (instance != null) {
            LoweredHandChangedEvent args_converted = args != 0L ? LoweredHandChangedEvent.getInstance(args, false) : null;
            for (LoweredHandListener listener : instance.OnHandLoweredListeners) {
                listener.onLoweredHand(args_converted);
            }
        }
    }

    public void addOnHandLoweredListener(LoweredHandListener listener) {
        this.OnHandLoweredListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnHandLowered", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raise_hand_call_feature_set_on_hand_lowered(this.handle, this.getHandle(), this));
    }

    public void removeOnHandLoweredListener(LoweredHandListener listener) {
        this.OnHandLoweredListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnHandLowered", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raise_hand_call_feature_set_on_hand_lowered(this.handle, 0L, null));
        }
    }

    public CompletableFuture<Void> raiseHand() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raise_hand_call_feature_raise_hand(handle, errorContext), (ErrorInfo)errorContext.value);
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> lowerHand() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raise_hand_call_feature_lower_hand(handle, errorContext), (ErrorInfo)errorContext.value);
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> lowerHandsInternal(final String[] participants) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raise_hand_call_feature_lower_hands_internal(handle, participants, participants.length));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> lowerAllHands() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raise_hand_call_feature_lower_all_hands(handle));
            }
        }, (Executor)executor);
    }

    static RaiseHandCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RaiseHandCallFeature, RaiseHandCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RaiseHandCallFeature, RaiseHandCallFeature.class, false);
    }

    private static RaiseHandCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RaiseHandCallFeature, RaiseHandCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnHandRaised")) {
            this.addOnHandRaisedListener((RaisedHandListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnHandLowered")) {
            this.addOnHandLoweredListener((LoweredHandListener)eventListener);
        }
    }

    public CompletableFuture<Void> lowerHands(Iterable<CommunicationIdentifier> identifiers) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : identifiers) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        return this.lowerHandsInternal(mris.toArray(mriArray));
    }
}

