/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamChannelMode;
import com.azure.android.communication.calling.AudioStreamFormat;
import com.azure.android.communication.calling.AudioStreamSampleRate;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;

public abstract class RawAudioStreamProperties {
    long handle;

    RawAudioStreamProperties(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_raw_audio_stream_properties_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_release(this.handle));
        this.handle = 0L;
    }

    public AudioStreamSampleRate getSampleRate() {
        Out<AudioStreamSampleRate> result = new Out<AudioStreamSampleRate>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_get_sample_rate(this.handle, result));
        return (AudioStreamSampleRate)((Object)result.value);
    }

    public RawAudioStreamProperties setSampleRate(AudioStreamSampleRate value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_set_sample_rate(this.handle, value));
        return this;
    }

    public AudioStreamChannelMode getChannelMode() {
        Out<AudioStreamChannelMode> result = new Out<AudioStreamChannelMode>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_get_channel_mode(this.handle, result));
        return (AudioStreamChannelMode)((Object)result.value);
    }

    public RawAudioStreamProperties setChannelMode(AudioStreamChannelMode value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_set_channel_mode(this.handle, value));
        return this;
    }

    public AudioStreamFormat getFormat() {
        Out<AudioStreamFormat> result = new Out<AudioStreamFormat>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_get_format(this.handle, result));
        return (AudioStreamFormat)((Object)result.value);
    }

    public RawAudioStreamProperties setFormat(AudioStreamFormat value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_audio_stream_properties_set_format(this.handle, value));
        return this;
    }
}

