/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamChannelMode;
import com.azure.android.communication.calling.AudioStreamFormat;
import com.azure.android.communication.calling.AudioStreamSampleRate;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawAudioStreamProperties;
import com.azure.android.communication.calling.Status;

public final class RawIncomingAudioStreamProperties
extends RawAudioStreamProperties {
    RawIncomingAudioStreamProperties(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_incoming_audio_stream_properties_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawIncomingAudioStreamProperties() {
        super(RawIncomingAudioStreamProperties.Create(), true);
    }

    @Override
    public RawIncomingAudioStreamProperties setSampleRate(AudioStreamSampleRate value) {
        super.setSampleRate(value);
        return this;
    }

    @Override
    public RawIncomingAudioStreamProperties setChannelMode(AudioStreamChannelMode value) {
        super.setChannelMode(value);
        return this;
    }

    @Override
    public RawIncomingAudioStreamProperties setFormat(AudioStreamFormat value) {
        super.setFormat(value);
        return this;
    }

    static RawIncomingAudioStreamProperties getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStreamProperties, RawIncomingAudioStreamProperties.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_audio_stream_properties_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawIncomingAudioStreamProperties, RawIncomingAudioStreamProperties.class, false);
    }
}

