/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamStateChangedEvent;
import com.azure.android.communication.calling.AudioStreamStateChangedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioStream;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RawAudioBuffer;
import com.azure.android.communication.calling.RawOutgoingAudioStreamOptions;
import com.azure.android.communication.calling.RawOutgoingAudioStreamProperties;
import com.azure.android.communication.calling.Status;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class RawOutgoingAudioStream
extends OutgoingAudioStream {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<AudioStreamStateChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<AudioStreamStateChangedListener>();

    RawOutgoingAudioStream(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RawOutgoingAudioStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(RawOutgoingAudioStreamOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_outgoing_audio_stream_create_raw_outgoing_audio_stream_options_options(options_converted, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawOutgoingAudioStream(RawOutgoingAudioStreamOptions options) {
        super(RawOutgoingAudioStream.Create(options), true);
    }

    public long getExpectedBufferSizeInBytes() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_get_expected_buffer_size_in_bytes(this.handle, result));
        return (Long)result.value;
    }

    public RawOutgoingAudioStreamProperties getProperties() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_get_properties(this.handle, result_handle));
        RawOutgoingAudioStreamProperties result_object = (Long)result_handle.value != 0L ? RawOutgoingAudioStreamProperties.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        RawOutgoingAudioStream instance = RawOutgoingAudioStream.getInstance(cookie);
        if (instance != null) {
            AudioStreamStateChangedEvent args_converted = args != 0L ? AudioStreamStateChangedEvent.getInstance(args, false) : null;
            for (AudioStreamStateChangedListener listener : instance.OnStateChangedListeners) {
                listener.onAudioStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(AudioStreamStateChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_set_on_state_changed(this.handle, 0L, null));
        }
    }

    public CompletableFuture<Void> sendRawAudioBuffer(final RawAudioBuffer rawAudioBuffer) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long rawAudioBuffer_converted = rawAudioBuffer != null ? rawAudioBuffer.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_raw_outgoing_audio_stream_send_raw_audio_buffer(handle, rawAudioBuffer_converted));
            }
        }, (Executor)executor);
    }

    static RawOutgoingAudioStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStream, RawOutgoingAudioStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_audio_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStream, RawOutgoingAudioStream.class, false);
    }

    private static RawOutgoingAudioStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStream, RawOutgoingAudioStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((AudioStreamStateChangedListener)eventListener);
        }
    }
}

