/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamBufferDuration;
import com.azure.android.communication.calling.AudioStreamChannelMode;
import com.azure.android.communication.calling.AudioStreamFormat;
import com.azure.android.communication.calling.AudioStreamSampleRate;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawAudioStreamProperties;
import com.azure.android.communication.calling.Status;

public final class RawOutgoingAudioStreamProperties
extends RawAudioStreamProperties {
    RawOutgoingAudioStreamProperties(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_raw_outgoing_audio_stream_properties_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public RawOutgoingAudioStreamProperties() {
        super(RawOutgoingAudioStreamProperties.Create(), true);
    }

    public AudioStreamBufferDuration getBufferDuration() {
        Out<AudioStreamBufferDuration> result = new Out<AudioStreamBufferDuration>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_properties_get_buffer_duration(this.handle, result));
        return (AudioStreamBufferDuration)((Object)result.value);
    }

    public RawOutgoingAudioStreamProperties setBufferDuration(AudioStreamBufferDuration value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_outgoing_audio_stream_properties_set_buffer_duration(this.handle, value));
        return this;
    }

    @Override
    public RawOutgoingAudioStreamProperties setSampleRate(AudioStreamSampleRate value) {
        super.setSampleRate(value);
        return this;
    }

    @Override
    public RawOutgoingAudioStreamProperties setChannelMode(AudioStreamChannelMode value) {
        super.setChannelMode(value);
        return this;
    }

    @Override
    public RawOutgoingAudioStreamProperties setFormat(AudioStreamFormat value) {
        super.setFormat(value);
        return this;
    }

    static RawOutgoingAudioStreamProperties getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStreamProperties, RawOutgoingAudioStreamProperties.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_audio_stream_properties_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawOutgoingAudioStreamProperties, RawOutgoingAudioStreamProperties.class, false);
    }
}

