/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RawVideoFrame;

public final class RawVideoFrameReceivedEvent {
    long handle;

    RawVideoFrameReceivedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_raw_video_frame_received_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_received_event_args_release(this.handle));
        this.handle = 0L;
    }

    public RawVideoFrame getFrame() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_received_event_args_get_frame(this.handle, result_handle));
        RawVideoFrame result_object = (Long)result_handle.value != 0L ? Factories.RawVideoFrameFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    public int getVideoStreamId() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_raw_video_frame_received_event_args_get_video_stream_id(this.handle, result));
        return (Integer)result.value;
    }

    static RawVideoFrameReceivedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawVideoFrameReceivedEvent, RawVideoFrameReceivedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_raw_video_frame_received_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RawVideoFrameReceivedEvent, RawVideoFrameReceivedEvent.class, false);
    }
}

