/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RealTimeTextInfoReceivedEvent;
import com.azure.android.communication.calling.RealTimeTextInfoReceivedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RealTimeTextCallFeature
extends CallFeature {
    private List<RealTimeTextInfoReceivedListener> OnInfoReceivedListeners = new CopyOnWriteArrayList<RealTimeTextInfoReceivedListener>();

    RealTimeTextCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RealTimeTextCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnInfoReceivedStaticHandler(long cookie, long args) {
        RealTimeTextCallFeature instance = RealTimeTextCallFeature.getInstance(cookie);
        if (instance != null) {
            RealTimeTextInfoReceivedEvent args_converted = args != 0L ? RealTimeTextInfoReceivedEvent.getInstance(args, false) : null;
            for (RealTimeTextInfoReceivedListener listener : instance.OnInfoReceivedListeners) {
                listener.onRealTimeTextInfoReceived(args_converted);
            }
        }
    }

    public void addOnInfoReceivedListener(RealTimeTextInfoReceivedListener listener) {
        this.OnInfoReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnInfoReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_call_feature_set_on_info_received(this.handle, this.getHandle(), this));
    }

    public void removeOnInfoReceivedListener(RealTimeTextInfoReceivedListener listener) {
        this.OnInfoReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnInfoReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_call_feature_set_on_info_received(this.handle, 0L, null));
        }
    }

    public void send(String text) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_call_feature_send_string_text(this.handle, text));
    }

    public void send(String text, boolean finalized) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_call_feature_send_string_text_boolean_finalized(this.handle, text, finalized));
    }

    static RealTimeTextCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RealTimeTextCallFeature, RealTimeTextCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RealTimeTextCallFeature, RealTimeTextCallFeature.class, false);
    }

    private static RealTimeTextCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RealTimeTextCallFeature, RealTimeTextCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnInfoReceived")) {
            this.addOnInfoReceivedListener((RealTimeTextInfoReceivedListener)eventListener);
        }
    }
}

