/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallerInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RealTimeTextResultType;
import java.util.Date;

public final class RealTimeTextInfo {
    long handle;

    RealTimeTextInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_real_time_text_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_release(this.handle));
        this.handle = 0L;
    }

    public CallerInfo getSender() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_sender(this.handle, result_handle));
        CallerInfo result_object = (Long)result_handle.value != 0L ? CallerInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public int getSequenceId() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_sequence_id(this.handle, result));
        return (Integer)result.value;
    }

    public String getText() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_text(this.handle, result));
        return (String)result.value;
    }

    public RealTimeTextResultType getResultType() {
        Out<RealTimeTextResultType> result = new Out<RealTimeTextResultType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_result_type(this.handle, result));
        return (RealTimeTextResultType)((Object)result.value);
    }

    public Date getReceivedTime() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_received_time(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    public Date getUpdatedTime() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_updated_time(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    public boolean isLocal() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_real_time_text_info_get_is_local(this.handle, result));
        return (Boolean)result.value;
    }

    static RealTimeTextInfo getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RealTimeTextInfo, RealTimeTextInfo.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_real_time_text_info_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RealTimeTextInfo, RealTimeTextInfo.class, false);
    }
}

