/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallEndReason;
import com.azure.android.communication.calling.CallParticipantRole;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.IncomingVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantState;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.RemoteVideoStreamsEvent;
import com.azure.android.communication.calling.RemoteVideoStreamsUpdatedListener;
import com.azure.android.communication.calling.VideoStreamStateChangedEvent;
import com.azure.android.communication.calling.VideoStreamStateChangedListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class RemoteParticipant {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<PropertyChangedListener> OnStateChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnIsMutedChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnIsSpeakingChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnDisplayNameChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnRoleChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<RemoteVideoStreamsUpdatedListener> OnVideoStreamsUpdatedListeners = new CopyOnWriteArrayList<RemoteVideoStreamsUpdatedListener>();
    private List<VideoStreamStateChangedListener> OnVideoStreamStateChangedListeners = new CopyOnWriteArrayList<VideoStreamStateChangedListener>();

    RemoteParticipant(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_remote_participant_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    RemoteParticipant(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_release(this.handle));
        this.handle = 0L;
    }

    public CallParticipantRole getCallParticipantRole() {
        Out<CallParticipantRole> result = new Out<CallParticipantRole>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_call_participant_role(this.handle, result));
        return (CallParticipantRole)((Object)result.value);
    }

    public String getDisplayName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_display_name(this.handle, result));
        return (String)result.value;
    }

    public boolean isMuted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_is_muted(this.handle, result));
        return (Boolean)result.value;
    }

    public boolean isSpeaking() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_is_speaking(this.handle, result));
        return (Boolean)result.value;
    }

    public CallEndReason getCallEndReason() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_call_end_reason(this.handle, result_handle));
        CallEndReason result_object = (Long)result_handle.value != 0L ? CallEndReason.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public ParticipantState getState() {
        Out<ParticipantState> result = new Out<ParticipantState>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_state(this.handle, result));
        return (ParticipantState)((Object)result.value);
    }

    @Deprecated
    public List<RemoteVideoStream> getVideoStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_video_streams(this.handle, result, result_length));
        ArrayList<RemoteVideoStream> resultList = new ArrayList<RemoteVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(RemoteVideoStream.getInstance(resultArray[i], true));
        }
        List<RemoteVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<IncomingVideoStream> getIncomingVideoStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_incoming_video_streams(this.handle, result, result_length));
        ArrayList<IncomingVideoStream> resultList = new ArrayList<IncomingVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(Factories.IncomingVideoStreamFactory(resultArray[i], true));
        }
        List<IncomingVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnStateChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(PropertyChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(PropertyChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_state_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsMutedChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnIsMutedChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_is_muted_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_is_muted_changed(this.handle, 0L, null));
        }
    }

    private static void OnIsSpeakingChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnIsSpeakingChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIsSpeakingChangedListener(PropertyChangedListener listener) {
        this.OnIsSpeakingChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsSpeakingChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_is_speaking_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsSpeakingChangedListener(PropertyChangedListener listener) {
        this.OnIsSpeakingChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsSpeakingChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_is_speaking_changed(this.handle, 0L, null));
        }
    }

    private static void OnDisplayNameChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnDisplayNameChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnDisplayNameChangedListener(PropertyChangedListener listener) {
        this.OnDisplayNameChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnDisplayNameChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_display_name_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnDisplayNameChangedListener(PropertyChangedListener listener) {
        this.OnDisplayNameChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnDisplayNameChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_display_name_changed(this.handle, 0L, null));
        }
    }

    private static void OnRoleChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnRoleChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnRoleChangedListener(PropertyChangedListener listener) {
        this.OnRoleChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnRoleChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_role_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnRoleChangedListener(PropertyChangedListener listener) {
        this.OnRoleChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnRoleChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_role_changed(this.handle, 0L, null));
        }
    }

    private static void OnVideoStreamsUpdatedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            RemoteVideoStreamsEvent args_converted = args != 0L ? RemoteVideoStreamsEvent.getInstance(args, false) : null;
            for (RemoteVideoStreamsUpdatedListener listener : instance.OnVideoStreamsUpdatedListeners) {
                listener.onRemoteVideoStreamsUpdated(args_converted);
            }
        }
    }

    @Deprecated
    public void addOnVideoStreamsUpdatedListener(RemoteVideoStreamsUpdatedListener listener) {
        this.OnVideoStreamsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoStreamsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_video_streams_updated(this.handle, this.getHandle(), this));
    }

    @Deprecated
    public void removeOnVideoStreamsUpdatedListener(RemoteVideoStreamsUpdatedListener listener) {
        this.OnVideoStreamsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoStreamsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_video_streams_updated(this.handle, 0L, null));
        }
    }

    private static void OnVideoStreamStateChangedStaticHandler(long cookie, long args) {
        RemoteParticipant instance = RemoteParticipant.getInstance(cookie);
        if (instance != null) {
            VideoStreamStateChangedEvent args_converted = args != 0L ? VideoStreamStateChangedEvent.getInstance(args, false) : null;
            for (VideoStreamStateChangedListener listener : instance.OnVideoStreamStateChangedListeners) {
                listener.onVideoStreamStateChanged(args_converted);
            }
        }
    }

    public void addOnVideoStreamStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnVideoStreamStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoStreamStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_video_stream_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnVideoStreamStateChangedListener(VideoStreamStateChangedListener listener) {
        this.OnVideoStreamStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoStreamStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_set_on_video_stream_state_changed(this.handle, 0L, null));
        }
    }

    private String getIdentifierInternal() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_participant_get_identifier_internal(this.handle, result));
        return (String)result.value;
    }

    public CompletableFuture<Void> mute() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_remote_participant_mute(handle, errorContext), (ErrorInfo)errorContext.value);
            }
        }, (Executor)executor);
    }

    static RemoteParticipant getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteParticipant, RemoteParticipant.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_remote_participant_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteParticipant, RemoteParticipant.class, false);
    }

    private static RemoteParticipant getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteParticipant, RemoteParticipant.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMutedChanged")) {
            this.addOnIsMutedChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsSpeakingChanged")) {
            this.addOnIsSpeakingChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnDisplayNameChanged")) {
            this.addOnDisplayNameChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnRoleChanged")) {
            this.addOnRoleChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoStreamsUpdated")) {
            this.addOnVideoStreamsUpdatedListener((RemoteVideoStreamsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoStreamStateChanged")) {
            this.addOnVideoStreamStateChangedListener((VideoStreamStateChangedListener)eventListener);
        }
    }

    public CommunicationIdentifier getIdentifier() {
        return IdentifierHelpers.from(this.getIdentifierInternal());
    }
}

