/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.CallSurvey;
import com.azure.android.communication.calling.CallSurveyResult;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class SurveyCallFeature
extends CallFeature {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    SurveyCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public CompletableFuture<CallSurvey> startSurvey() {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallSurvey>(){

            public CallSurvey get() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_survey_call_feature_start_survey(handle, result_handle, errorContext), (ErrorInfo)errorContext.value);
                CallSurvey result_object = CallSurvey.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    private CompletableFuture<CallSurveyResult> submitSurveyInternal(final CallSurvey survey) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallSurveyResult>(){

            public CallSurveyResult get() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                long survey_converted = survey != null ? survey.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_survey_call_feature_submit_survey_internal(handle, survey_converted, result_handle, errorContext), (ErrorInfo)errorContext.value);
                CallSurveyResult result_object = CallSurveyResult.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static SurveyCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SurveyCallFeature, SurveyCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.SurveyCallFeature, SurveyCallFeature.class, false);
    }

    public CompletableFuture<CallSurveyResult> submitSurvey(CallSurvey survey) {
        survey.setOverallIssues(survey.getOverallIssues()).setAudioIssues(survey.getAudioIssues()).setVideoIssues(survey.getVideoIssues()).setScreenShareIssues(survey.getScreenShareIssues());
        return this.submitSurveyInternal(survey);
    }
}

