/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CommonCallAgent;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.JoinTeamsCallOptions;
import com.azure.android.communication.calling.JoinTeamsMeetingLocator;
import com.azure.android.communication.calling.ModeInCommunicationHelper;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.StartTeamsCallOptions;
import com.azure.android.communication.calling.TeamsCall;
import com.azure.android.communication.calling.TeamsCallsUpdatedEvent;
import com.azure.android.communication.calling.TeamsCallsUpdatedListener;
import com.azure.android.communication.calling.TeamsIncomingCall;
import com.azure.android.communication.calling.TeamsIncomingCallListener;
import com.azure.android.communication.calling.TelecomConnectionManager;
import com.azure.android.communication.calling.TelecomManagerIncomingCallEvent;
import com.azure.android.communication.calling.TelecomManagerIncomingCallListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TeamsCallAgent
extends CommonCallAgent {
    private List<TeamsCallsUpdatedListener> OnCallsUpdatedListeners = new CopyOnWriteArrayList<TeamsCallsUpdatedListener>();
    private List<TeamsIncomingCallListener> OnIncomingCallListeners = new CopyOnWriteArrayList<TeamsIncomingCallListener>();
    private List<TelecomManagerIncomingCallListener> TelecomManagerOnIncomingCallListeners = new CopyOnWriteArrayList<TelecomManagerIncomingCallListener>();

    TeamsCallAgent(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    TeamsCallAgent(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public List<TeamsCall> getCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_get_calls(this.handle, result, result_length));
        ArrayList<TeamsCall> resultList = new ArrayList<TeamsCall>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(TeamsCall.getInstance(resultArray[i], true));
        }
        List<TeamsCall> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private boolean isTelecomManagerEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_get_is_telecom_manager_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    private String getTelecomManagerAccountId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_get_telecom_manager_account_id(this.handle, result));
        return (String)result.value;
    }

    private static void OnCallsUpdatedStaticHandler(long cookie, long args) {
        TeamsCallAgent instance = TeamsCallAgent.getInstance(cookie);
        if (instance != null) {
            TeamsCallsUpdatedEvent args_converted = args != 0L ? TeamsCallsUpdatedEvent.getInstance(args, false) : null;
            for (TeamsCallsUpdatedListener listener : instance.OnCallsUpdatedListeners) {
                listener.onTeamsCallsUpdated(args_converted);
            }
        }
    }

    public void addOnCallsUpdatedListener(TeamsCallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_on_calls_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnCallsUpdatedListener(TeamsCallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_on_calls_updated(this.handle, 0L, null));
        }
    }

    private static void OnIncomingCallStaticHandler(long cookie, long incomingCall) {
        TeamsCallAgent instance = TeamsCallAgent.getInstance(cookie);
        if (instance != null) {
            TeamsIncomingCall incomingCall_converted = incomingCall != 0L ? TeamsIncomingCall.getInstance(incomingCall, false) : null;
            for (TeamsIncomingCallListener listener : instance.OnIncomingCallListeners) {
                listener.onTeamsIncomingCall(incomingCall_converted);
            }
        }
    }

    public void addOnIncomingCallListener(TeamsIncomingCallListener listener) {
        this.OnIncomingCallListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIncomingCall", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_on_incoming_call(this.handle, this.getHandle(), this));
    }

    public void removeOnIncomingCallListener(TeamsIncomingCallListener listener) {
        this.OnIncomingCallListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIncomingCall", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_on_incoming_call(this.handle, 0L, null));
        }
    }

    private static void TelecomManagerOnIncomingCallStaticHandler(long cookie, long args) {
        TeamsCallAgent instance = TeamsCallAgent.getInstance(cookie);
        if (instance != null) {
            TelecomManagerIncomingCallEvent args_converted = args != 0L ? TelecomManagerIncomingCallEvent.getInstance(args, false) : null;
            for (TelecomManagerIncomingCallListener listener : instance.TelecomManagerOnIncomingCallListeners) {
                listener.onTelecomManagerIncomingCall(args_converted);
            }
        }
    }

    private void addTelecomManagerOnIncomingCallListener(TelecomManagerIncomingCallListener listener) {
        this.TelecomManagerOnIncomingCallListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "TelecomManagerOnIncomingCall", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_telecom_manager_on_incoming_call(this.handle, this.getHandle(), this));
    }

    private void removeTelecomManagerOnIncomingCallListener(TelecomManagerIncomingCallListener listener) {
        this.TelecomManagerOnIncomingCallListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "TelecomManagerOnIncomingCall", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_set_telecom_manager_on_incoming_call(this.handle, 0L, null));
        }
    }

    private TeamsCall startCallWithContext(Context context, String participant, StartTeamsCallOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_start_call_with_context(this.handle, context, participant, options_converted, result_handle));
        TeamsCall result_object = (Long)result_handle.value != 0L ? TeamsCall.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private TeamsCall joinInternal(JoinTeamsMeetingLocator meetingLocator, JoinTeamsCallOptions joinTeamsCallOptions) {
        long meetingLocator_converted = meetingLocator != null ? meetingLocator.getHandle() : 0L;
        long joinTeamsCallOptions_converted = joinTeamsCallOptions != null ? joinTeamsCallOptions.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_agent_join_internal(this.handle, meetingLocator_converted, joinTeamsCallOptions_converted, result_handle));
        TeamsCall result_object = (Long)result_handle.value != 0L ? TeamsCall.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static TeamsCallAgent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallAgent, TeamsCallAgent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_call_agent_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallAgent, TeamsCallAgent.class, false);
    }

    private static TeamsCallAgent getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallAgent, TeamsCallAgent.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallsUpdated")) {
            this.addOnCallsUpdatedListener((TeamsCallsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIncomingCall")) {
            this.addOnIncomingCallListener((TeamsIncomingCallListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "TelecomManagerOnIncomingCall")) {
            this.addTelecomManagerOnIncomingCallListener((TelecomManagerIncomingCallListener)eventListener);
        }
    }

    public TeamsCall startCall(Context context, CommunicationIdentifier participant, StartTeamsCallOptions startTeamsCallOptions) {
        String participantString = IdentifierHelpers.toMRI(participant);
        PermissionUtility.throwIfNotAppropriatePermissions(context, startTeamsCallOptions != null ? startTeamsCallOptions.getOutgoingVideoOptions() : null, startTeamsCallOptions != null ? startTeamsCallOptions.getOutgoingAudioOptions() : null);
        TeamsCall teamsCall = this.startCallWithContext(context, participantString, startTeamsCallOptions);
        if (startTeamsCallOptions != null && startTeamsCallOptions.getOutgoingAudioOptions() != null && startTeamsCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, teamsCall);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, teamsCall.getHandle(), this.getTelecomManagerAccountId());
        }
        return teamsCall;
    }

    public TeamsCall startCall(Context context, CommunicationIdentifier participant) {
        String participantString = IdentifierHelpers.toMRI(participant);
        StartTeamsCallOptions callWithAudioOnly = new StartTeamsCallOptions();
        OutgoingAudioOptions outgoingAudioOptions = new OutgoingAudioOptions();
        outgoingAudioOptions.setMuted(false);
        callWithAudioOnly.setOutgoingAudioOptions(outgoingAudioOptions);
        PermissionUtility.throwIfNotAppropriatePermissions(context, null, outgoingAudioOptions);
        TeamsCall teamsCall = this.startCallWithContext(context, participantString, callWithAudioOnly);
        if (callWithAudioOnly != null && callWithAudioOnly.getOutgoingAudioOptions() != null && callWithAudioOnly.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, teamsCall);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, teamsCall.getHandle(), this.getTelecomManagerAccountId());
        }
        return teamsCall;
    }

    public TeamsCall join(Context context, JoinTeamsMeetingLocator meetingLocator, JoinTeamsCallOptions joinTeamsCallOptions) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, joinTeamsCallOptions != null ? joinTeamsCallOptions.getOutgoingVideoOptions() : null, joinTeamsCallOptions != null ? joinTeamsCallOptions.getOutgoingAudioOptions() : null);
        TeamsCall teamsCall = this.joinInternal(meetingLocator, joinTeamsCallOptions);
        if (joinTeamsCallOptions != null && joinTeamsCallOptions.getOutgoingAudioOptions() != null && joinTeamsCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, teamsCall);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, teamsCall.getHandle(), this.getTelecomManagerAccountId());
        }
        return teamsCall;
    }

    public TeamsCall join(Context context, JoinTeamsMeetingLocator meetingLocator) {
        JoinTeamsCallOptions joinTeamsCallOptions = new JoinTeamsCallOptions();
        PermissionUtility.throwIfNotAppropriatePermissions(context, joinTeamsCallOptions != null ? joinTeamsCallOptions.getOutgoingVideoOptions() : null, joinTeamsCallOptions != null ? joinTeamsCallOptions.getOutgoingAudioOptions() : null);
        TeamsCall teamsCall = this.joinInternal(meetingLocator, joinTeamsCallOptions);
        if (joinTeamsCallOptions != null && joinTeamsCallOptions.getOutgoingAudioOptions() != null && joinTeamsCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, teamsCall);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, teamsCall.getHandle(), this.getTelecomManagerAccountId());
        }
        return teamsCall;
    }

    void addTelecomManagerOnIncomingCallListenerInternal(TelecomManagerIncomingCallListener listener) {
        this.addTelecomManagerOnIncomingCallListener(listener);
    }

    static void TriggerOnIncomingCallStaticHandler(long cookie, long incomingCall) {
        TeamsCallAgent.OnIncomingCallStaticHandler(cookie, incomingCall);
    }
}

