/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import androidx.annotation.RequiresApi;
import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CommonCallAgentOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.TelecomManagerOptions;

public final class TeamsCallAgentOptions
extends CommonCallAgentOptions {
    TeamsCallAgentOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_teams_call_agent_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public TeamsCallAgentOptions() {
        super(TeamsCallAgentOptions.Create(), true);
    }

    @Override
    public TeamsCallAgentOptions setDisableInternalPushForIncomingCall(boolean value) {
        super.setDisableInternalPushForIncomingCall(value);
        return this;
    }

    @Override
    @RequiresApi(value=25)
    public TeamsCallAgentOptions setTelecomManagerOptions(TelecomManagerOptions value) {
        super.setTelecomManagerOptions(value);
        return this;
    }

    static TeamsCallAgentOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallAgentOptions, TeamsCallAgentOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_call_agent_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallAgentOptions, TeamsCallAgentOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

