/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class TeamsCallInfo {
    long handle;

    TeamsCallInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_teams_call_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_info_release(this.handle));
        this.handle = 0L;
    }

    public String getMeetingThreadId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_call_info_get_meeting_thread_id(this.handle, result));
        return (String)result.value;
    }

    static TeamsCallInfo getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallInfo, TeamsCallInfo.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_teams_call_info_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallInfo, TeamsCallInfo.class, false);
    }
}

