/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.TeamsCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TeamsCallsUpdatedEvent {
    long handle;

    TeamsCallsUpdatedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_teams_calls_updated_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_calls_updated_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<TeamsCall> getAddedCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_calls_updated_event_args_get_added_calls(this.handle, result, result_length));
        ArrayList<TeamsCall> resultList = new ArrayList<TeamsCall>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(TeamsCall.getInstance(resultArray[i], true));
        }
        List<TeamsCall> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<TeamsCall> getRemovedCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_calls_updated_event_args_get_removed_calls(this.handle, result, result_length));
        ArrayList<TeamsCall> resultList = new ArrayList<TeamsCall>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(TeamsCall.getInstance(resultArray[i], true));
        }
        List<TeamsCall> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static TeamsCallsUpdatedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallsUpdatedEvent, TeamsCallsUpdatedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_teams_calls_updated_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCallsUpdatedEvent, TeamsCallsUpdatedEvent.class, false);
    }
}

