/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallCaptions;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.TeamsCaptionsListener;
import com.azure.android.communication.calling.TeamsCaptionsReceivedEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class TeamsCaptions
extends CallCaptions {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<PropertyChangedListener> OnCaptionsEnabledChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnActiveSpokenLanguageChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnActiveCaptionLanguageChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<TeamsCaptionsListener> OnCaptionsReceivedListeners = new CopyOnWriteArrayList<TeamsCaptionsListener>();

    TeamsCaptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    TeamsCaptions(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public String getActiveCaptionLanguage() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_get_active_caption_language(this.handle, result));
        return (String)result.value;
    }

    public List<String> getSupportedCaptionLanguages() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_get_supported_caption_languages(this.handle, result, result_length));
        return Arrays.asList((String[])result.value);
    }

    private String[] getSupportedCaptionLanguagesInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_get_supported_caption_languages_internal(this.handle, result, result_length));
        return (String[])result.value;
    }

    private static void OnCaptionsEnabledChangedStaticHandler(long cookie, long args) {
        TeamsCaptions instance = TeamsCaptions.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnCaptionsEnabledChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnCaptionsEnabledChangedListener(PropertyChangedListener listener) {
        this.OnCaptionsEnabledChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCaptionsEnabledChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_captions_enabled_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnCaptionsEnabledChangedListener(PropertyChangedListener listener) {
        this.OnCaptionsEnabledChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCaptionsEnabledChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_captions_enabled_changed(this.handle, 0L, null));
        }
    }

    private static void OnActiveSpokenLanguageChangedStaticHandler(long cookie, long args) {
        TeamsCaptions instance = TeamsCaptions.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnActiveSpokenLanguageChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnActiveSpokenLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveSpokenLanguageChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnActiveSpokenLanguageChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_active_spoken_language_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnActiveSpokenLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveSpokenLanguageChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnActiveSpokenLanguageChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_active_spoken_language_changed(this.handle, 0L, null));
        }
    }

    private static void OnActiveCaptionLanguageChangedStaticHandler(long cookie, long args) {
        TeamsCaptions instance = TeamsCaptions.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnActiveCaptionLanguageChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnActiveCaptionLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveCaptionLanguageChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnActiveCaptionLanguageChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_active_caption_language_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnActiveCaptionLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveCaptionLanguageChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnActiveCaptionLanguageChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_active_caption_language_changed(this.handle, 0L, null));
        }
    }

    private static void OnCaptionsReceivedStaticHandler(long cookie, long args) {
        TeamsCaptions instance = TeamsCaptions.getInstance(cookie);
        if (instance != null) {
            TeamsCaptionsReceivedEvent args_converted = args != 0L ? TeamsCaptionsReceivedEvent.getInstance(args, false) : null;
            for (TeamsCaptionsListener listener : instance.OnCaptionsReceivedListeners) {
                listener.onTeamsCaptions(args_converted);
            }
        }
    }

    public void addOnCaptionsReceivedListener(TeamsCaptionsListener listener) {
        this.OnCaptionsReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCaptionsReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_captions_received(this.handle, this.getHandle(), this));
    }

    public void removeOnCaptionsReceivedListener(TeamsCaptionsListener listener) {
        this.OnCaptionsReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCaptionsReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_captions_set_on_captions_received(this.handle, 0L, null));
        }
    }

    public CompletableFuture<Void> setCaptionLanguage(final String language) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_teams_captions_set_caption_language(handle, language, errorContext), (ErrorInfo)errorContext.value);
            }
        }, (Executor)executor);
    }

    static TeamsCaptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCaptions, TeamsCaptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_captions_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCaptions, TeamsCaptions.class, false);
    }

    private static TeamsCaptions getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsCaptions, TeamsCaptions.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCaptionsEnabledChanged")) {
            this.addOnCaptionsEnabledChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnActiveSpokenLanguageChanged")) {
            this.addOnActiveSpokenLanguageChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnActiveCaptionLanguageChanged")) {
            this.addOnActiveCaptionLanguageChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCaptionsReceived")) {
            this.addOnCaptionsReceivedListener((TeamsCaptionsListener)eventListener);
        }
    }
}

