/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.JoinTeamsMeetingLocator;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class TeamsMeetingIdLocator
extends JoinTeamsMeetingLocator {
    TeamsMeetingIdLocator(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(String meetingId, String passcode) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_teams_meeting_id_locator_create_string_meeting_id_string_passcode(meetingId, passcode, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public TeamsMeetingIdLocator(String meetingId, String passcode) {
        super(TeamsMeetingIdLocator.Create(meetingId, passcode), true);
    }

    public String getMeetingId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_meeting_id_locator_get_meeting_id(this.handle, result));
        return (String)result.value;
    }

    public String getPasscode() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_meeting_id_locator_get_passcode(this.handle, result));
        return (String)result.value;
    }

    static TeamsMeetingIdLocator getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsMeetingIdLocator, TeamsMeetingIdLocator.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_join_meeting_locator_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsMeetingIdLocator, TeamsMeetingIdLocator.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

