/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.telecom.CallAudioState;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import androidx.annotation.RequiresApi;
import com.azure.android.communication.calling.CallAgent;
import com.azure.android.communication.calling.CallEndReason;
import com.azure.android.communication.calling.CommonCall;
import com.azure.android.communication.calling.CommonIncomingCall;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.IncomingCall;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.TeamsCallAgent;
import com.azure.android.communication.calling.TeamsIncomingCall;
import com.azure.android.communication.calling.TelecomConnectionManager;

@RequiresApi(api=26)
class TelecomConnection
extends Connection
implements PropertyChangedListener {
    private static final String TAG = "TelecomConnection";
    private CommonCall call;
    private long incomingCallHandle;
    private long callAgentHandle;
    private String callKind;

    static TelecomConnection createOutgoingConnection(long callHandle) {
        TelecomConnection connection = new TelecomConnection();
        connection.setCall(callHandle);
        return connection;
    }

    static TelecomConnection createIncomingConnection(long incomingCallHandle, long callAgentHandle, String callKind) {
        TelecomConnection connection = new TelecomConnection();
        connection.incomingCallHandle = incomingCallHandle;
        connection.callAgentHandle = callAgentHandle;
        connection.callKind = callKind;
        return connection;
    }

    private TelecomConnection() {
    }

    @Override
    public void onPropertyChanged(PropertyChangedEvent propertyChangedEvent) {
        if (this.call != null) {
            this.processStateChange(this.call);
        }
    }

    public void onCallAudioStateChanged(CallAudioState state) {
        Log.debug1(TAG, "onCallAudioStateChanged: %s", state.toString());
    }

    public void onHold() {
        Log.debug1(TAG, "onHold", new Object[0]);
        try {
            if (this.call != null) {
                this.call.hold();
            }
        }
        catch (Exception ex) {
            Log.debug1(TAG, "onHold: %s", ex.getMessage());
        }
    }

    public void onUnhold() {
        Log.debug1(TAG, "onUnhold", new Object[0]);
    }

    public void onShowIncomingCallUi() {
        Log.debug1(TAG, "onShowIncomingCallUi", new Object[0]);
        try {
            CommonIncomingCall incomingCall = null;
            if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_GROUP)) {
                incomingCall = IncomingCall.getInstance(this.incomingCallHandle, false);
            }
            if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_TEAMS)) {
                incomingCall = TeamsIncomingCall.getInstance(this.incomingCallHandle, false);
            }
            incomingCall.setTelecomConnection(this);
            incomingCall.addOnCallEndedListener(listener -> this.missCall());
            if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_GROUP)) {
                CallAgent.TriggerOnIncomingCallStaticHandler(this.callAgentHandle, this.incomingCallHandle);
            }
            if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_TEAMS)) {
                TeamsCallAgent.TriggerOnIncomingCallStaticHandler(this.callAgentHandle, this.incomingCallHandle);
            }
        }
        catch (Exception ex) {
            Log.debug1(TAG, "onShowIncomingCallUi: %s", ex.getMessage());
        }
    }

    public void onDisconnect() {
        this.disconnect(2);
    }

    public void onAnswer() {
        CommonIncomingCall incomingCall;
        Log.debug1(TAG, "onAnswer", new Object[0]);
        if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_GROUP) && (incomingCall = IncomingCall.getInstance(this.incomingCallHandle, true)) != null) {
            Log.debug1(TAG, "onAnswer: accepting incomingCall", new Object[0]);
            ((IncomingCall)incomingCall).accept(TelecomConnectionManager.getContext(), null);
        }
        if (this.callKind.equals(TelecomConnectionManager.EXTRA_CALL_KIND_TEAMS) && (incomingCall = TeamsIncomingCall.getInstance(this.incomingCallHandle, true)) != null) {
            Log.debug1(TAG, "onAnswer: accepting incomingCall", new Object[0]);
            ((TeamsIncomingCall)incomingCall).accept(TelecomConnectionManager.getContext(), null);
        }
    }

    public void accept(CommonCall call) {
        Log.debug1(TAG, "accept", new Object[0]);
        this.setCall(call);
        this.setActive();
    }

    public void reject() {
        this.disconnect(6);
    }

    public void missCall() {
        this.disconnect(2);
    }

    private void disconnect(int cause) {
        this.setDisconnected(new DisconnectCause(cause, ""));
        if (this.call != null) {
            this.call.setTelecomConnection(null);
        }
        this.destroy();
    }

    private void setCall(long callHandle) {
        this.setCall(Factories.CommonCallFactory(callHandle, false));
    }

    private void setCall(CommonCall call) {
        Log.debug1(TAG, "setCall", new Object[0]);
        try {
            this.call = call;
            call.setTelecomConnection(this);
            call.addOnStateChangedListener(this);
        }
        catch (Exception ex) {
            Log.debug1(TAG, "TelecomConnection is not able to get call: %s", ex.getMessage());
        }
    }

    private void processStateChange(CommonCall call) {
        Log.debug1(TAG, "processStateChange: %s", new Object[]{call.getState()});
        switch (call.getState()) {
            case NONE: {
                break;
            }
            case CONNECTING: {
                this.setDialing();
                break;
            }
            case CONNECTED: 
            case DISCONNECTING: 
            case EARLY_MEDIA: 
            case IN_LOBBY: {
                this.setActive();
                break;
            }
            case RINGING: {
                this.setRinging();
                break;
            }
            case DISCONNECTED: {
                CallEndReason callEndReason = call.getCallEndReason();
                if (callEndReason == null || callEndReason.getCode() == 0) {
                    this.disconnect(2);
                } else {
                    this.disconnect(3);
                }
                call.removeOnStateChangedListener(this);
                this.call = null;
                break;
            }
            case LOCAL_HOLD: 
            case REMOTE_HOLD: {
                this.setOnHold();
            }
        }
    }
}

