/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.TelecomConnectionService;
import java.lang.reflect.Method;

@RequiresApi(api=26)
class TelecomConnectionManager {
    private static final String TAG = "TelecomConnectionManager";
    private static Context context;
    static String EXTRA_CALL_HANDLE;
    static String EXTRA_INCOMING_CALL_HANDLE;
    static String EXTRA_CALL_AGENT_HANDLE;
    static String EXTRA_VIDEO_CALL;
    static String EXTRA_CALL_KIND;
    static String EXTRA_CALL_KIND_GROUP;
    static String EXTRA_CALL_KIND_TEAMS;

    TelecomConnectionManager() {
    }

    static void setContext(Context context) {
        TelecomConnectionManager.context = context;
    }

    static Context getContext() {
        return context;
    }

    static void startIncomingConnection(@NonNull Context context, long incomingCallHandle, long callAgentHandle, String phoneAccountId) {
        TelecomConnectionManager.startIncomingConnection(context, incomingCallHandle, callAgentHandle, EXTRA_CALL_KIND_GROUP, phoneAccountId);
    }

    static void startTeamsIncomingConnection(@NonNull Context context, long incomingCallHandle, long callAgentHandle, String phoneAccountId) {
        TelecomConnectionManager.startIncomingConnection(context, incomingCallHandle, callAgentHandle, EXTRA_CALL_KIND_TEAMS, phoneAccountId);
    }

    private static void startIncomingConnection(@NonNull Context context, long incomingCallHandle, long callAgentHandle, String callKind, String phoneAccountId) {
        TelecomManager telecomManager = (TelecomManager)context.getSystemService("telecom");
        ComponentName componentName = new ComponentName(context, TelecomConnectionService.class.getName());
        PhoneAccountHandle phoneAccountHandle = new PhoneAccountHandle(componentName, phoneAccountId);
        TelecomConnectionManager.registerPhoneAccount(telecomManager, phoneAccountHandle, phoneAccountId);
        if (TelecomConnectionManager.isTelecomManagerAvailable(context, telecomManager, phoneAccountHandle)) {
            Log.debug1(TAG, "startIncomingConnection", new Object[0]);
            try {
                Bundle extras = new Bundle();
                Uri uri = Uri.fromParts((String)"tel", (String)"ACS Call", null);
                extras.putParcelable("android.telecom.extra.INCOMING_CALL_ADDRESS", (Parcelable)uri);
                extras.putParcelable("android.telecom.extra.PHONE_ACCOUNT_HANDLE", (Parcelable)phoneAccountHandle);
                extras.putLong(EXTRA_INCOMING_CALL_HANDLE, incomingCallHandle);
                extras.putLong(EXTRA_CALL_AGENT_HANDLE, callAgentHandle);
                extras.putString(EXTRA_CALL_KIND, callKind);
                telecomManager.addNewIncomingCall(phoneAccountHandle, extras);
                Log.debug1(TAG, "startIncomingConnection completed", new Object[0]);
            }
            catch (Exception e) {
                Log.debug1(TAG, "startIncomingConnection failed: " + e.getMessage(), new Object[0]);
            }
        }
    }

    static void startOutgoingConnection(@NonNull Context context, long callHandle, String phoneAccountId) {
        TelecomManager telecomManager = (TelecomManager)context.getSystemService("telecom");
        ComponentName componentName = new ComponentName(context, TelecomConnectionService.class.getName());
        PhoneAccountHandle phoneAccountHandle = new PhoneAccountHandle(componentName, phoneAccountId);
        TelecomConnectionManager.registerPhoneAccount(telecomManager, phoneAccountHandle, phoneAccountId);
        if (TelecomConnectionManager.isTelecomManagerAvailable(context, telecomManager, phoneAccountHandle)) {
            Log.debug1(TAG, "startOutgoingConnection", new Object[0]);
            try {
                Bundle callExtras = new Bundle();
                callExtras.putLong(EXTRA_CALL_HANDLE, callHandle);
                Bundle extras = new Bundle();
                extras.putParcelable("android.telecom.extra.OUTGOING_CALL_EXTRAS", (Parcelable)callExtras);
                extras.putParcelable("android.telecom.extra.PHONE_ACCOUNT_HANDLE", (Parcelable)phoneAccountHandle);
                extras.putBoolean("android.telecom.extra.START_CALL_WITH_SPEAKERPHONE", true);
                Uri uri = Uri.fromParts((String)"tel", (String)"123456789", (String)"");
                telecomManager.placeCall(uri, extras);
            }
            catch (Exception e) {
                Log.error(TAG, "startOutgoingCall: " + e.getMessage(), new Object[0]);
            }
        } else {
            Log.debug1(TAG, "startOutgoingCall: Permission not granted", new Object[0]);
        }
    }

    private static boolean isTelecomManagerAvailable(Context context, TelecomManager telecomManager, PhoneAccountHandle phoneAccountHandle) {
        boolean isManageOwnCallsPermissionGranted = TelecomConnectionManager.isPermissionGranted(context, "android.permission.MANAGE_OWN_CALLS");
        Log.debug1(TAG, "isTelecomManagerAvailable:  is ManageOwnCalls permissions granted: %b, telecom manager exists: %b, phone account handle exists: %b", isManageOwnCallsPermissionGranted, telecomManager != null, phoneAccountHandle != null);
        return telecomManager != null && phoneAccountHandle != null && isManageOwnCallsPermissionGranted;
    }

    private static boolean isPermissionGranted(Context context, String permission2) {
        return context.checkSelfPermission(permission2) == 0;
    }

    private static void registerPhoneAccount(TelecomManager telecomManager, PhoneAccountHandle phoneAccountHandle, String phoneAccountId) {
        TelecomConnectionManager.clearExistingAccounts(telecomManager);
        PhoneAccount account = PhoneAccount.builder((PhoneAccountHandle)phoneAccountHandle, (CharSequence)phoneAccountId).setCapabilities(2048).build();
        try {
            telecomManager.registerPhoneAccount(account);
            Log.error(TAG, "registerPhoneAccount successfully", new Object[0]);
        }
        catch (Exception ex) {
            Log.debug1(TAG, "registerPhoneAccount failed: " + ex.getMessage(), new Object[0]);
        }
    }

    private static void clearExistingAccounts(TelecomManager telecomManager) {
        try {
            Method clearMethod = TelecomManager.class.getMethod("clearPhoneAccounts", null);
            clearMethod.invoke((Object)telecomManager, new Object[0]);
            Log.debug1(TAG, "Called clearPhoneAccounts successfully", new Object[0]);
        }
        catch (Exception ex) {
            Log.debug1(TAG, "clearExistingAccounts failed: " + ex.getMessage(), new Object[0]);
        }
    }

    static {
        EXTRA_CALL_HANDLE = "callHandle";
        EXTRA_INCOMING_CALL_HANDLE = "incomingCallHandle";
        EXTRA_CALL_AGENT_HANDLE = "callAgentHandle";
        EXTRA_VIDEO_CALL = "videoCall";
        EXTRA_CALL_KIND = "callKind";
        EXTRA_CALL_KIND_GROUP = "callKind_group";
        EXTRA_CALL_KIND_TEAMS = "callKind_teams";
    }
}

