/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.os.Bundle;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.PhoneAccountHandle;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.TelecomConnection;
import com.azure.android.communication.calling.TelecomConnectionManager;

public final class TelecomConnectionService
extends ConnectionService {
    private static final String TAG = "TelecomConnectionService";

    public Connection onCreateIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        Log.debug1(TAG, "onCreateIncomingConnection", new Object[0]);
        Bundle originalBundle = request.getExtras();
        long incomingCallHandle = originalBundle.getLong(TelecomConnectionManager.EXTRA_INCOMING_CALL_HANDLE);
        long callAgentHandle = originalBundle.getLong(TelecomConnectionManager.EXTRA_CALL_AGENT_HANDLE);
        String callKind = originalBundle.getString(TelecomConnectionManager.EXTRA_CALL_KIND);
        TelecomConnection connection = TelecomConnection.createIncomingConnection(incomingCallHandle, callAgentHandle, callKind);
        connection.setExtras(originalBundle);
        connection.setConnectionProperties(128);
        connection.setConnectionCapabilities(3);
        connection.setAudioModeIsVoip(true);
        Log.debug1(TAG, "onCreateIncomingConnection created", new Object[0]);
        return connection;
    }

    public Connection onCreateOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        Log.debug1(TAG, "onCreateOutgoingConnection", new Object[0]);
        Bundle originalBundle = request.getExtras();
        long callHandle = originalBundle.getLong(TelecomConnectionManager.EXTRA_CALL_HANDLE);
        TelecomConnection connection = TelecomConnection.createOutgoingConnection(callHandle);
        connection.setExtras(originalBundle);
        connection.setConnectionProperties(128);
        connection.setConnectionCapabilities(3);
        connection.setAudioModeIsVoip(true);
        Log.debug1(TAG, "onCreateOutgoingConnection created", new Object[0]);
        return connection;
    }
}

