/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CommonCallAgent;
import com.azure.android.communication.calling.CommonIncomingCall;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

final class TelecomManagerIncomingCallEvent {
    long handle;

    TelecomManagerIncomingCallEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_telecom_manager_incoming_call_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_telecom_manager_incoming_call_event_args_release(this.handle));
        this.handle = 0L;
    }

    public CommonIncomingCall getIncomingCall() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_telecom_manager_incoming_call_event_args_get_incoming_call(this.handle, result_handle));
        CommonIncomingCall result_object = (Long)result_handle.value != 0L ? Factories.CommonIncomingCallFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CommonCallAgent getCallagent() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_telecom_manager_incoming_call_event_args_get_callagent(this.handle, result_handle));
        CommonCallAgent result_object = (Long)result_handle.value != 0L ? Factories.CommonCallAgentFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    static TelecomManagerIncomingCallEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TelecomManagerIncomingCallEvent, TelecomManagerIncomingCallEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_telecom_manager_incoming_call_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TelecomManagerIncomingCallEvent, TelecomManagerIncomingCallEvent.class, false);
    }
}

