/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingVideoConstraints;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class VideoConstraints {
    long handle;

    VideoConstraints(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_constraints_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public VideoConstraints() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_video_constraints_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_constraints_release(this.handle));
        this.handle = 0L;
    }

    public OutgoingVideoConstraints getOutgoingVideoConstraints() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_constraints_get_outgoing_video_constraints(this.handle, result_handle));
        OutgoingVideoConstraints result_object = (Long)result_handle.value != 0L ? OutgoingVideoConstraints.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public VideoConstraints setOutgoingVideoConstraints(OutgoingVideoConstraints value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_constraints_set_outgoing_video_constraints(this.handle, value_converted));
        return this;
    }

    static VideoConstraints getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoConstraints, VideoConstraints.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_constraints_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoConstraints, VideoConstraints.class, false);
    }
}

