/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public final class VideoOptions {
    long handle;

    VideoOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public VideoOptions(LocalVideoStream[] localVideoStreams) {
        long[] localVideoStreams_converted = new long[localVideoStreams.length];
        for (int i = 0; i < localVideoStreams.length; ++i) {
            localVideoStreams_converted[i] = localVideoStreams[i].handle;
        }
        Out<Long> result_handle = new Out<Long>();
        if (localVideoStreams == null || localVideoStreams.length == 0 || localVideoStreams[0] == null) {
            throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS);
        }
        Status resultStatus = NativeLibrary.sam_video_options_create_local_video_streams(localVideoStreams_converted, localVideoStreams.length, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_options_release(this.handle));
        this.handle = 0L;
    }

    public List<LocalVideoStream> getLocalVideoStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_options_get_local_video_streams(this.handle, result, result_length));
        ArrayList<LocalVideoStream> resultList = new ArrayList<LocalVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(LocalVideoStream.getInstance(resultArray[i], true));
        }
        List<LocalVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static VideoOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoOptions, VideoOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoOptions, VideoOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

