/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import com.azure.android.communication.calling.IInternalPreviewRenderer;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.calling.VideoStreamView;

@SuppressLint(value={"ViewConstructor"})
public final class VideoStreamRendererView
extends FrameLayout
implements TextureView.SurfaceTextureListener,
IInternalPreviewRenderer.Callback,
VideoOrientationManager.OrientationChangedCallback {
    private final Context context;
    private final VideoStreamView videoStreamView;
    private boolean disposed = false;

    VideoStreamRendererView(Context context, VideoStreamView videoStreamView) {
        super(context);
        this.context = context;
        this.videoStreamView = videoStreamView;
        this.setClipChildren(true);
        this.setClipToOutline(true);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> this.addView((View)videoStreamView));
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            Handler uiHandler = new Handler(Looper.getMainLooper());
            uiHandler.post(() -> this.removeView((View)this.videoStreamView));
        }
    }

    public void updateScalingMode(ScalingMode scalingMode) {
        this.videoStreamView.UpdateScalingMode(scalingMode);
    }

    public boolean isRendering() {
        return true;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void onOrientationChanged(int causeId) {
    }

    @Override
    public void onFrameSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
    }

    @Override
    public void onPreviewSurfaceUnset(SurfaceTexture surfaceTexture) {
    }
}

