/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallVideoStream;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class VideoStreamStateChangedEvent {
    long handle;

    VideoStreamStateChangedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_stream_state_changed_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_state_changed_event_args_release(this.handle));
        this.handle = 0L;
    }

    public CallVideoStream getStream() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_state_changed_event_args_get_stream(this.handle, result_handle));
        CallVideoStream result_object = (Long)result_handle.value != 0L ? Factories.CallVideoStreamFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    public String getMessage() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_state_changed_event_args_get_message(this.handle, result));
        return (String)result.value;
    }

    static VideoStreamStateChangedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamStateChangedEvent, VideoStreamStateChangedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_stream_state_changed_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamStateChangedEvent, VideoStreamStateChangedEvent.class, false);
    }
}

