/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import java.util.LinkedList;
import java.util.Queue;

abstract class VideoStreamView
extends FrameLayout {
    private static final String TAG = "VideoStreamView";
    private static final float VIEW_SIZE_THRESHOLD = 5.0f;
    protected Context context;
    protected TextureView textureView;
    protected SurfaceTexture surfaceTexture;
    protected ScalingMode scalingMode;
    protected RendererListener callback;
    protected StreamSize streamSize = null;
    protected Queue<TextureView> textureViewQueue;
    protected int w;
    protected int h;

    VideoStreamView(Context context, ScalingMode scalingMode) {
        super(context);
        this.context = context;
        this.scalingMode = scalingMode;
        this.textureViewQueue = new LinkedList<TextureView>();
        this.setClipChildren(true);
        this.setClipToOutline(true);
    }

    protected void ScaleTextureView() {
        Log.debug1(TAG, "ScaleTextureView, videoId: %s, scaling TextureView: %d", this.GetCorrelationId(), System.identityHashCode(this.textureView));
        if (this.textureView == null) {
            Log.debug1(TAG, "ScaleTextureView, videoId: %s, scaling aborted due to invalid TextureView", this.GetCorrelationId());
            return;
        }
        if (this.w == 0 || this.h == 0) {
            Log.debug1(TAG, "ScaleTextureView, videoId: %s, scaling aborted due to invalid video frame size", this.GetCorrelationId());
            return;
        }
        float viewW = this.getWidth();
        float viewH = this.getHeight();
        Log.debug1(TAG, "ScaleTextureView, videoId: %s, calculation parameters, view w: %f x h: %f, video frame w: %d x h: %d", this.GetCorrelationId(), Float.valueOf(viewW), Float.valueOf(viewH), this.w, this.h);
        float scaleFactorX = viewW / (float)this.w;
        float scaleFactorY = viewH / (float)this.h;
        float scale = 0.0f;
        switch (this.scalingMode) {
            case FIT: {
                Log.debug1(TAG, "ScaleTextureView, videoId: %s, fitting video frame", this.GetCorrelationId());
                scale = Math.min(scaleFactorX, scaleFactorY);
                break;
            }
            case CROP: {
                Log.debug1(TAG, "ScaleTextureView, videoId: %s, cropping video frame", this.GetCorrelationId());
                scale = Math.max(scaleFactorX, scaleFactorY);
            }
        }
        float scaledW = scale * (float)this.w;
        float scaledH = scale * (float)this.h;
        float scaleX = scaledW / viewW;
        float scaleY = scaledH / viewH;
        Log.debug1(TAG, "ScaleTextureView, videoId: %s, scale factor: %f, scaled w: %f x h: %f, scaled x: %f, y: %f", this.GetCorrelationId(), Float.valueOf(scale), Float.valueOf(scaledW), Float.valueOf(scaledH), Float.valueOf(scaleX), Float.valueOf(scaleY));
        if (Math.abs(scaledW - viewW) < 5.0f && Math.abs(scaledH - viewH) < 5.0f) {
            Log.debug1(TAG, "ScaleTextureView, videoId: %s, Scaled w x h are almost the same meaning the video view container matches the video frame aspect ratio", this.GetCorrelationId());
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleX, scaleY, viewW / 2.0f, viewH / 2.0f);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            if (this.textureView == null) {
                Log.debug1(TAG, "ScaleTextureView, videoId: %s, scaling aborted due to invalid TextureView", this.GetCorrelationId());
                return;
            }
            Log.debug1(TAG, "ScaleTextureView, videoId: %s, applying transformation on viewId: %d", this.GetCorrelationId(), System.identityHashCode(this.textureView));
            this.textureView.setTransform(matrix);
        });
    }

    void UpdateScalingMode(ScalingMode scalingMode) {
        Log.debug1(TAG, "UpdateScalingMode, videoId: %s, new mode: %d, old mode: %d", this.GetCorrelationId(), scalingMode.ordinal(), this.scalingMode.ordinal());
        this.scalingMode = scalingMode;
        this.ScaleTextureView();
    }

    protected void onSizeChanged(int newW, int newH, int oldW, int oldH) {
        super.onSizeChanged(newW, newH, oldW, oldH);
        Log.debug1(TAG, "onSizeChanged, videoId: %s, new w: %d x h: %d, old w: %d x h: %d", this.GetCorrelationId(), newW, newH, oldW, oldH);
        this.ScaleTextureView();
    }

    protected StreamSize GetVideoFrameSize() {
        return this.streamSize;
    }

    protected TextureView GetTextureView() {
        return this.textureView;
    }

    protected void AddTextureView() {
        this.textureViewQueue.add(this.textureView);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            if (!this.textureViewQueue.isEmpty()) {
                Log.debug1(TAG, "AddTextureView, videoId: %s, adding TextureView: %d to VideoStreamView: %d", this.GetCorrelationId(), System.identityHashCode(this.textureView), System.identityHashCode((Object)this));
                this.textureView = this.textureViewQueue.peek();
                this.addView((View)this.textureView);
            }
        });
    }

    protected void RemoveTextureView() {
        if (this.textureView != null) {
            this.textureView.setSurfaceTextureListener(null);
            this.textureView = null;
        }
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            if (!this.textureViewQueue.isEmpty()) {
                TextureView textureView = this.textureViewQueue.remove();
                Log.debug1(TAG, "RemoveTextureView, videoId: %s, removing TextureView: %d from VideoStreamView: %d", this.GetCorrelationId(), System.identityHashCode(textureView), System.identityHashCode((Object)this));
                this.removeView((View)textureView);
            }
        });
    }

    protected abstract String GetCorrelationId();
}

