/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.Status;
import java.util.UUID;

final class ViewLifecycleTelemetryEvent {
    long handle;

    ViewLifecycleTelemetryEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_view_lifecycle_telemetry_event_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public ViewLifecycleTelemetryEvent(UUID viewId) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_view_lifecycle_telemetry_event_create_guid_view_id(viewId, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_release(this.handle));
        this.handle = 0L;
    }

    public UUID getViewId() {
        Out<UUID> result = new Out<UUID>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_get_view_id(this.handle, result));
        return (UUID)result.value;
    }

    public static ViewLifecycleTelemetryEvent createForLocalStream(UUID viewId, LocalVideoStream localStream) {
        long localStream_converted = localStream != null ? localStream.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(NativeLibrary.sam_view_lifecycle_telemetry_event_create_for_local_stream(viewId, localStream_converted, result_handle));
        ViewLifecycleTelemetryEvent result_object = (Long)result_handle.value != 0L ? ViewLifecycleTelemetryEvent.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public static ViewLifecycleTelemetryEvent createForRemoteStream(UUID viewId, RemoteVideoStream remoteStream) {
        long remoteStream_converted = remoteStream != null ? remoteStream.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(NativeLibrary.sam_view_lifecycle_telemetry_event_create_for_remote_stream(viewId, remoteStream_converted, result_handle));
        ViewLifecycleTelemetryEvent result_object = (Long)result_handle.value != 0L ? ViewLifecycleTelemetryEvent.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public void sendCreateViewAttempt() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_create_view_attempt(this.handle));
    }

    public void sendCreateViewSuccess(int width, int height) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_create_view_success(this.handle, width, height));
    }

    public void sendCreateViewFailed(String reason) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_create_view_failed(this.handle, reason));
    }

    public void sendDisposeViewAttempt() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_dispose_view_attempt(this.handle));
    }

    public void sendDisposeViewSuccess() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_dispose_view_success(this.handle));
    }

    public void sendDisposeViewFailed(String reason) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_view_lifecycle_telemetry_event_send_dispose_view_failed(this.handle, reason));
    }

    static ViewLifecycleTelemetryEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ViewLifecycleTelemetryEvent, ViewLifecycleTelemetryEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_view_lifecycle_telemetry_event_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ViewLifecycleTelemetryEvent, ViewLifecycleTelemetryEvent.class, false);
    }
}

