/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public final class Platform {
    private static final File DEFAULT_CACHE_DIR = new File("/sdcard");
    private static PlatformInfo platformInfo;

    private Platform() {
    }

    public static synchronized void initialize(Context context) {
        if (platformInfo == null) {
            platformInfo = new PlatformInfo(context);
        }
    }

    public static synchronized PlatformInfo getInfo() {
        return platformInfo;
    }

    public static native long getTimestamp();

    public static class PlatformInfo {
        private final File cacheDir;
        private final File storageDir;
        private final Context appContext;
        private final String simpleClassName = this.getClass().getSimpleName();

        public PlatformInfo(Context context) {
            this.cacheDir = context != null ? context.getCacheDir() : DEFAULT_CACHE_DIR;
            this.storageDir = Environment.getExternalStorageDirectory();
            this.appContext = context;
        }

        public final File getCacheDir() {
            return this.cacheDir;
        }

        public final File getStorageDir() {
            return this.storageDir;
        }

        public final Context getAppContext() {
            return this.appContext;
        }

        public final String toString() {
            return this.simpleClassName + " [cacheDir=" + this.cacheDir + ", storageDir=" + this.storageDir + "]";
        }
    }
}

