/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.capture;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import com.skype.android.video.capture.IPreviewBinding;
import com.skype.android.video.capture.PreviewBinding;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiPreviewBinding
implements IPreviewBinding.Callback {
    private final Handler handler;
    private final Callback cb;
    private PreviewBinding previewBinding;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private boolean canUsePreviewBinding = false;
    private boolean isBindingCallbackActive = false;
    private List<SurfaceTexture> mostRecentSurfaces;
    private Queue<SurfaceTexture> unsetSurfacesWaitingToBeNotified = new LinkedList<SurfaceTexture>();
    private Queue<SurfaceTexture> surfacesToUnsetNext = new LinkedList<SurfaceTexture>();

    public UiPreviewBinding(Handler handler, Callback cb) {
        this.handler = handler;
        this.cb = cb;
    }

    public BindingParams setup() {
        if (this.isStarted) {
            throw new IllegalStateException("can not setup twice");
        }
        this.isStarted = true;
        this.previewBinding = new PreviewBinding(this);
        return this.getBindingParams(this.previewBinding);
    }

    public BindingParams destroy() {
        if (!this.isStarted || this.isStopped) {
            throw new IllegalStateException("can not destroy twice or before setup");
        }
        this.isStopped = true;
        this.canUsePreviewBinding = false;
        return this.getBindingParams(this.previewBinding);
    }

    public void setSurface(SurfaceTexture surface) {
        ArrayList<SurfaceTexture> surfaces = null;
        if (surface != null) {
            surfaces = new ArrayList<SurfaceTexture>(1);
            surfaces.add(surface);
        }
        this.setSurfaces(surfaces);
    }

    public void setSurfaces(List<SurfaceTexture> surfaces) {
        this.notifyOnPreviewSurfaceUnset(this.unsetSurfacesWaitingToBeNotified);
        if (this.mostRecentSurfaces != null) {
            for (SurfaceTexture surface : this.mostRecentSurfaces) {
                this.surfacesToUnsetNext.add(surface);
            }
        }
        this.mostRecentSurfaces = surfaces;
        if (this.canUsePreviewBinding) {
            this.previewBinding.setPreviewSurface(surfaces);
        } else if (!this.isBindingCallbackActive) {
            this.notifyOnPreviewSurfaceUnset(this.surfacesToUnsetNext);
        }
    }

    private void notifyOnPreviewSurfaceUnset(Queue<SurfaceTexture> surfaces) {
        while (!surfaces.isEmpty()) {
            this.cb.onPreviewSurfaceUnset(surfaces.remove());
        }
    }

    private BindingParams getBindingParams(PreviewBinding pb) {
        BindingParams params = new BindingParams();
        params.type = pb.getNativeBindingType();
        params.event = pb.getNativeBindingEvent();
        return params;
    }

    @Override
    public void onBindingCreated(long binding) {
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.canUsePreviewBinding = UiPreviewBinding.this.isStarted && !UiPreviewBinding.this.isStopped;
                if (UiPreviewBinding.this.canUsePreviewBinding) {
                    UiPreviewBinding.this.isBindingCallbackActive = true;
                    if (UiPreviewBinding.this.mostRecentSurfaces != null) {
                        UiPreviewBinding.this.previewBinding.setPreviewSurface(UiPreviewBinding.this.mostRecentSurfaces);
                    }
                }
            }
        });
    }

    @Override
    public void onBindingReleased() {
        this.previewBinding.dispose();
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.isBindingCallbackActive = false;
            }
        });
    }

    @Override
    public void onBindingFailed() {
        this.previewBinding.dispose();
        this.handler.post(new Runnable(){

            public void run() {
                UiPreviewBinding.this.cb.onBindingFailed();
            }
        });
    }

    @Override
    public void onFrameSizeChanged(Object holder, final int width, final int height) {
        final List surfaces = (List)holder;
        this.handler.post(new Runnable(){

            public void run() {
                if (UiPreviewBinding.this.mostRecentSurfaces == surfaces) {
                    for (SurfaceTexture surface : surfaces) {
                        UiPreviewBinding.this.cb.onFrameSizeChanged(surface, width, height);
                    }
                }
            }
        });
    }

    @Override
    public void onPreviewSurfaceUnset(Object holder) {
        final List surfaces = (List)holder;
        this.handler.post(new Runnable(){

            public void run() {
                for (SurfaceTexture surface : surfaces) {
                    if (UiPreviewBinding.this.surfacesToUnsetNext.remove(surface)) {
                        UiPreviewBinding.this.cb.onPreviewSurfaceUnset(surface);
                        continue;
                    }
                    UiPreviewBinding.this.unsetSurfacesWaitingToBeNotified.add(surface);
                }
            }
        });
    }

    public static interface Callback {
        public void onFrameSizeChanged(SurfaceTexture var1, int var2, int var3);

        public void onPreviewSurfaceUnset(SurfaceTexture var1);

        public void onBindingFailed();
    }

    public class BindingParams {
        public int type;
        public long event;
    }
}

