/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import com.skype.android.video.render.EGLException;
import com.skype.android.video.render.EGLRenderSurface;

@TargetApi(value=17)
class EGL14RenderSurface
implements EGLRenderSurface {
    private EGLDisplay eglDisplay;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface eglSurface;

    EGL14RenderSurface() {
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglSurface = EGL14.EGL_NO_SURFACE;
    }

    public void create(SurfaceTexture surfaceTexture) {
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new EGLException("eglGetDisplay EGL14.EGL_NO_DISPLAY");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new EGLException("eglInitialize");
        }
        int[] configAttrs = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])configAttrs, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            EGLException.check("eglChooseConfig");
        }
        int[] contextAttrs = new int[]{12440, 2, 12344};
        this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextAttrs, (int)0);
        EGLException.check("eglCreateContext");
        int[] surfaceAttrs = new int[]{12344};
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)configs[0], (Object)surfaceTexture, (int[])surfaceAttrs, (int)0);
        EGLException.check("eglCreateWindowSurface");
    }

    public void makeCurrent(boolean current) {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)(current ? this.eglSurface : EGL14.EGL_NO_SURFACE), (EGLSurface)(current ? this.eglSurface : EGL14.EGL_NO_SURFACE), (EGLContext)(current ? this.eglContext : EGL14.EGL_NO_CONTEXT))) {
            throw new EGLException("eglMakeCurrent");
        }
    }

    public void swapBuffers() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
            throw new EGLException("eglSwapBuffers");
        }
    }

    public void destroy(boolean releaseThread) {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY) {
            try {
                this.makeCurrent(false);
            }
            finally {
                EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
                EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
                if (releaseThread) {
                    EGL14.eglReleaseThread();
                }
                this.eglDisplay = EGL14.EGL_NO_DISPLAY;
                this.eglSurface = EGL14.EGL_NO_SURFACE;
                this.eglContext = EGL14.EGL_NO_CONTEXT;
            }
        }
    }
}

