/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.media;

import android.content.Context;
import android.util.Log;
import com.microsoft.dl.audio.AudioPlatform;
import com.microsoft.media.Interop;
import com.microsoft.media.RtcPalEnvironment;

public class NGCPcmHost {
    private static String TAG = "NGCPcmHost";
    private final boolean m_manageAudioManagerModes;
    public static final int PCMIF_OK = 0;
    public static final int PCMIF_ERROR = 1;
    public static final int PCMIF_ERROR_NOT_INITIALIZED = 3;
    public static final int PCMIF_ERROR_UNKNOWN_DEVICE = 4;
    public static final int PCMIF_NOT_INITIALIZED_ROUTE_CACHED = 5;

    public NGCPcmHost(Context ctx, boolean hasPhone, boolean manageModes, boolean clientRouting, AudioPlatform.clientCallback callback) {
        this.m_manageAudioManagerModes = manageModes;
        AudioPlatform.setAudioContext((Context)ctx);
        AudioPlatform.updateClientCallback((boolean)clientRouting, (AudioPlatform.clientCallback)callback);
    }

    public int SetRoute(String str) {
        int result = 3;
        if (AudioPlatform.isMediaInitialized()) {
            if (this.m_manageAudioManagerModes) {
                AudioPlatform.setMode((int)3);
            }
            try {
                AudioRoute route;
                if (str.equals("EARPIECE") || str.equals("0_1") || str.equals("1_1") || str.equals("2_1")) {
                    route = AudioRoute.EARPIECE;
                } else if (str.equals("SPEAKER") || str.equals("0_2") || str.equals("1_2") || str.equals("2_2")) {
                    route = AudioRoute.SPEAKER;
                } else if (str.equals("BLUETOOTH") || str.equals("0_3") || str.equals("1_3") || str.equals("2_3")) {
                    route = AudioRoute.BLUETOOTH;
                } else if (str.equals("HEADSET_WITH_MIC") || str.equals("0_4") || str.equals("1_4") || str.equals("2_4")) {
                    route = AudioRoute.HEADSET_WITH_MIC;
                } else if (str.equals("HEADSET_WITHOUT_MIC") || str.equals("0_5") || str.equals("1_5") || str.equals("2_5")) {
                    route = AudioRoute.HEADSET_WITHOUT_MIC;
                } else {
                    Log.e((String)TAG, (String)("SetRoute - unknown device: " + str));
                    return 4;
                }
                RtcPalEnvironment.setActiveEndpoint(Interop.SkypeToLyncEndpoint(route));
                result = 0;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)TAG, (String)"SetRoute - error calling NGC stack, stack may be unloaded", (Throwable)e);
            }
        } else {
            try {
                AudioPlatform.cacheRoute((String)str);
                result = 5;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)TAG, (String)"SetRoute - error calling NGC stack, stack may be unloaded", (Throwable)e);
            }
        }
        return result;
    }

    public static enum AudioRoute {
        EARPIECE,
        SPEAKER,
        BLUETOOTH,
        HEADSET_WITH_MIC,
        HEADSET_WITHOUT_MIC;

    }
}

