/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.media;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.microsoft.dl.Platform;
import com.microsoft.dl.audio.AudioPlatform;
import com.microsoft.media.NetworkPal;
import com.microsoft.media.RtcPalConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class RtcPalEnvironment {
    private static String TAG = "RtcPalEnvironment";
    private static Context _context;
    private static boolean _palInited;

    private static native void setAppPath(String var0);

    private static native boolean isRelease();

    private static native void setTracePath(String var0);

    public static void setContext(Context ctx) {
        _context = ctx;
    }

    public static void initialize() {
        if (_context != null) {
            RtcPalEnvironment.initialize(_context);
            Log.i((String)TAG, (String)"Pal initialization completed");
        } else {
            Log.e((String)TAG, (String)"Initialization failed, context was not set");
        }
    }

    private static void closeSilently(Closeable cs) {
        try {
            if (cs != null) {
                cs.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean initialize(Context ctx, String path) {
        boolean result = false;
        result = RtcPalEnvironment.initialize(ctx);
        if (result) {
            RtcPalEnvironment.setTracePath(path);
        }
        return result;
    }

    public static boolean initialize(Context ctx) {
        block10: {
            if (!NetworkPal.initialize(ctx)) {
                if (RtcPalConfig.isLogcatEnabled()) {
                    Log.e((String)TAG, (String)"NetworkPal initialization failed");
                }
                throw new ExceptionInInitializerError("NetworkPal initialization failed");
            }
            if (ctx != null) {
                Platform.initialize((Context)ctx);
            }
            File app = ctx.getFilesDir().getParentFile();
            RtcPalEnvironment.setAppPath(app.toString());
            String state = Environment.getExternalStorageState();
            if ("mounted".equals(state)) {
                File file = new File(ctx.getExternalCacheDir(), "");
                if (!file.exists()) {
                    Log.v((String)TAG, (String)"file doesn't exist");
                    try {
                        if (file.createNewFile()) {
                            Log.v((String)TAG, (String)("createNewFile() succeeded, file exist status: " + file.exists()));
                            RtcPalEnvironment.setTracePath(file.toString());
                            break block10;
                        }
                        Log.v((String)TAG, (String)("createNewFile() failed, file exist status: " + file.exists()));
                    }
                    catch (IOException ex) {
                        Log.e((String)TAG, (String)("createNewFile() IOException: " + ex.toString()));
                    }
                } else {
                    Log.v((String)TAG, (String)("file already exists " + file.toString()));
                    RtcPalEnvironment.setTracePath(file.toString());
                }
            } else {
                Log.v((String)TAG, (String)"media not mounted");
            }
        }
        _palInited = true;
        return true;
    }

    public static void uninitialize() {
        AudioPlatform.uninitialize();
        _palInited = false;
    }

    public static boolean IsPalInitialized() {
        return _palInited;
    }

    public static void setConversationActivity(Activity activity) {
        activity.setVolumeControlStream(0);
    }

    private static String toString(AudioEndpoint endpoint) {
        String StrValue = endpoint == AudioEndpoint.SPEAKER ? "Speaker" : (endpoint == AudioEndpoint.NON_SPEAKER ? "Non_speaker" : (endpoint == AudioEndpoint.BLUETOOTH ? "Bluetooth" : (endpoint == AudioEndpoint.EARPIECE ? "Earpiece" : (endpoint == AudioEndpoint.HEADSET_WITH_MIC ? "Headset_with_mic" : (endpoint == AudioEndpoint.HEADSET_WITHOUT_MIC ? "Headset_without_mic" : "Invalid route")))));
        return StrValue;
    }

    public static int setActiveEndpoint(AudioEndpoint endpoint) {
        Log.v((String)TAG, (String)("setActiveEndpoint(" + endpoint.getAudioEndpoint() + ")"));
        AudioPlatform.setRoute((String)RtcPalEnvironment.toString(endpoint));
        return 1;
    }

    public static void setVolumeChange() {
        Log.v((String)TAG, (String)"setVolumeChange");
        AudioPlatform.setVolumeChange();
    }

    static {
        _palInited = false;
    }

    public static enum AudioEndpoint {
        SPEAKER(1),
        NON_SPEAKER(2),
        BLUETOOTH(4),
        EARPIECE(8),
        HEADSET_WITH_MIC(16),
        HEADSET_WITHOUT_MIC(32);

        private int mValue;

        private AudioEndpoint(int value) {
            this.mValue = value;
        }

        public int getAudioEndpoint() {
            return this.mValue;
        }
    }
}

