/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class VolumeController {
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static final String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static final String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    private final int STREAM_BLUETOOTH_SCO = 6;
    private final int STREAM_VOICE_CALL = 0;
    private AudioManager audioManager;
    private static VolumeController javaInstance = null;
    private static long nativeInstance = 0L;
    private int lastVolumeBeforeMute = 0;
    private final Executor backgroundExecutor = Executors.newSingleThreadExecutor();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (VolumeController.VOLUME_CHANGED_ACTION.equals(action)) {
                int streamType = intent.getIntExtra(VolumeController.EXTRA_VOLUME_STREAM_TYPE, -1);
                int newVolLevel = intent.getIntExtra(VolumeController.EXTRA_VOLUME_STREAM_VALUE, 0);
                int oldVolLevel = intent.getIntExtra(VolumeController.EXTRA_PREV_VOLUME_STREAM_VALUE, 0);
                if (streamType != -1) {
                    if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                        Log.i((String)"DLAudioJava", (String)("BroadcastReceiver:onReceive streamType=" + streamType + ", newVolLevel=" + newVolLevel + ", oldVolLevel=" + oldVolLevel + ", maxVolume=" + VolumeController.this.audioManager.getStreamMaxVolume(streamType)));
                    }
                } else {
                    Log.log((int)6, (String)"DLAudioJava", (String)"BroadcastReceiver:onReceive: failed to get stream type.");
                }
                if (newVolLevel != oldVolLevel) {
                    final boolean isMuted = newVolLevel == 0;
                    final BroadcastReceiver.PendingResult pendingResult = this.goAsync();
                    VolumeController.this.backgroundExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VolumeController.this.onVolumeChange(isMuted);
                            }
                            finally {
                                pendingResult.finish();
                            }
                        }
                    });
                }
            }
        }
    };

    private static native void onVolumeChange(long var0, boolean var2);

    public VolumeController() {
        Context ctx = Platform.getInfo().getAppContext();
        this.audioManager = (AudioManager)ctx.getSystemService("audio");
        if (javaInstance == null) {
            javaInstance = this;
        }
    }

    public synchronized void registerNativeInstance(long nInstance) {
        nativeInstance = nInstance;
    }

    public synchronized void unregisterNativeInstance() {
        nativeInstance = 0L;
    }

    public void registerVolumeIntentReceiver() {
        Context ctx = Platform.getInfo().getAppContext();
        if (ctx == null || this.mReceiver == null) {
            Log.log((int)5, (String)"DLAudioJava", (String)"volume registerReceiver failed - no context");
            return;
        }
        try {
            IntentFilter filter = new IntentFilter(VOLUME_CHANGED_ACTION);
            ctx.registerReceiver(this.mReceiver, filter);
        }
        catch (IllegalStateException ex) {
            Log.log((int)6, (String)"DLAudioJava", (String)("An error occurred registerReceiver: ex=" + ex));
        }
    }

    public void unregisterVolumeIntentReceiver() {
        Context ctx = Platform.getInfo().getAppContext();
        if (ctx == null || this.mReceiver == null) {
            Log.log((int)5, (String)"DLAudioJava", (String)"volume unregisterReceiver failed - no context");
            return;
        }
        try {
            ctx.unregisterReceiver(this.mReceiver);
        }
        catch (IllegalStateException ex) {
            Log.log((int)6, (String)"DLAudioJava", (String)("An error occurred unregisterReceiver: ex=" + ex));
        }
    }

    private synchronized void onVolumeChange(boolean isMuted) {
        if (nativeInstance != 0L) {
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)"onVolumeChange triggered");
            }
            VolumeController.onVolumeChange(nativeInstance, isMuted);
        }
    }

    private boolean isBluetooth() {
        return this.audioManager.isBluetoothScoOn();
    }

    private int getStreamType() {
        return this.isBluetooth() ? 6 : 0;
    }

    public int getStreamVolume() {
        int currentVolume = this.audioManager.getStreamVolume(this.getStreamType());
        int volume = this.translateToDLRange(currentVolume);
        return volume;
    }

    public void setStreamVolume(int index) {
        int max_index = this.getStreamMaxVolume();
        if (index > max_index) {
            index = this.translateToDeviceRange(index);
        }
        this.audioManager.setStreamVolume(this.getStreamType(), index, 1);
    }

    public int getStreamMaxVolume() {
        return this.audioManager.getStreamMaxVolume(this.getStreamType());
    }

    public boolean isStreamMuted() {
        return this.getStreamVolume() == 0;
    }

    public void setMute(boolean mute) {
        if (mute && !this.isStreamMuted()) {
            this.lastVolumeBeforeMute = this.getStreamVolume();
            this.setStreamVolume(0);
        }
        if (!mute && this.isStreamMuted()) {
            this.setStreamVolume(this.lastVolumeBeforeMute);
        }
    }

    public boolean isMicMuted() {
        boolean mute = this.audioManager.isMicrophoneMute();
        return mute;
    }

    public void setMicMute(boolean mute) {
        this.audioManager.setMicrophoneMute(mute);
    }

    private int translateToDeviceRange(int dlIndex) {
        double DL_MAX_RANGE = 65535.0;
        double conversionFactor = (double)this.getStreamMaxVolume() / DL_MAX_RANGE;
        int result = (int)Math.ceil(conversionFactor * (double)dlIndex);
        return result;
    }

    private int translateToDLRange(int deviceIndex) {
        double DL_MAX_RANGE = 65535.0;
        int maxVolume = this.getStreamMaxVolume();
        int result = 0;
        if (maxVolume != 0) {
            double conversionFactor = DL_MAX_RANGE / (double)maxVolume;
            result = (int)Math.ceil(conversionFactor * (double)deviceIndex);
        }
        return result;
    }

    public void setVolumeChange() {
        this.onVolumeChange(this.isStreamMuted());
    }
}

