/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx;

import android.os.Build;
import com.skype.android.jipc.omx.CallRouter;
import com.skype.android.jipc.omx.OmxFacade;
import com.skype.android.jipc.omx.OmxObserver;
import com.skype.android.jipc.omx.ServicePath;
import com.skype.android.jipc.omx.api.j.CallRouterImpl;

public class OmxInventory {
    private static final ThreadLocal<OmxFacade> holder = new ThreadLocal<OmxFacade>(){

        @Override
        protected OmxFacade initialValue() {
            return AndroidApiLevel.supported.facade();
        }
    };

    public static OmxFacade obtainFacade() {
        return holder.get();
    }

    public static OmxObserver obtainObserver() {
        return AndroidApiLevel.supported.observer();
    }

    static enum AndroidApiLevel {
        UNSUPPORTED(Integer.MIN_VALUE, 17){

            @Override
            public CallRouter router() {
                throw new UnsupportedOperationException(Build.VERSION.CODENAME);
            }
        }
        ,
        JELLYBEAN_MR2(18){

            @Override
            public CallRouter router() {
                return new CallRouterImpl();
            }
        }
        ,
        KITKAT(19, 20){

            @Override
            public CallRouter router() {
                return new com.skype.android.jipc.omx.api.k.CallRouterImpl();
            }
        }
        ,
        LOLLIPOP(21, 22){

            @Override
            public CallRouter router() {
                return new com.skype.android.jipc.omx.api.l.CallRouterImpl();
            }
        }
        ,
        MARSHMALLOW(23){

            @Override
            public CallRouter router() {
                return new com.skype.android.jipc.omx.api.m.CallRouterImpl();
            }
        }
        ,
        PREVIEW_N(24, Integer.MAX_VALUE){

            @Override
            public CallRouter router() {
                return new com.skype.android.jipc.omx.api.n.CallRouterImpl();
            }
        };

        final int since;
        final int until;
        static final AndroidApiLevel supported;

        private AndroidApiLevel(int since, int until) {
            this.since = since;
            this.until = until;
        }

        private AndroidApiLevel(int single) {
            this(single, single);
        }

        private boolean matches(int sdkInt) {
            return sdkInt >= this.since && sdkInt <= this.until;
        }

        private static AndroidApiLevel match(int sdkInt) {
            for (AndroidApiLevel level : AndroidApiLevel.values()) {
                if (!level.matches(sdkInt)) continue;
                return level;
            }
            return UNSUPPORTED;
        }

        abstract CallRouter router();

        ServicePath servicePath() {
            return this.ordinal() < PREVIEW_N.ordinal() ? ServicePath.MONOLITHIC : ServicePath.FRIGHTENED;
        }

        final OmxFacade facade() {
            return new OmxFacade(this.servicePath(), this.router());
        }

        final OmxObserver observer() {
            return new OmxObserver(this.router());
        }

        static {
            supported = AndroidApiLevel.match(Build.VERSION.SDK_INT);
        }
    }
}

