/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx.data;

import android.os.IBinder;
import com.skype.android.jipc.inout.OutInt32;
import com.skype.android.jipc.inout.OutMayBe;
import com.skype.android.jipc.omx.OmxFacade;
import com.skype.android.jipc.omx.enums.OmxIndex;

public class ExtendedIndex
implements OmxIndex {
    public static final int EXTENSION_UNSUPPORTED = OmxIndex.Component.OMX_IndexComponentStartUnused.value();
    private final String name;
    private final int majorVersion;
    private final int minorVersion;
    private int value = EXTENSION_UNSUPPORTED;
    private int queriedOnNodeId = -1;

    public ExtendedIndex(String name, int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.name = name;
    }

    public void queryValueOnce(OmxFacade facade, IBinder omx, int nodeId) {
        if (this.queriedOnNodeId != nodeId) {
            this.queryValue(facade, omx, nodeId);
        }
    }

    public int getQueriedOnNodeId() {
        return this.queriedOnNodeId;
    }

    public void queryValue(OmxFacade facade, IBinder omx, int nodeId) {
        OutMayBe<Void, OutInt32> result = facade.getExtensionIndex(omx, nodeId, this.name);
        this.setValue(result.status.isOk() ? ((OutInt32)result.value).value() : EXTENSION_UNSUPPORTED);
        this.queriedOnNodeId = nodeId;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isSupported() {
        return this.value != EXTENSION_UNSUPPORTED;
    }

    @Override
    public int value() {
        return this.value;
    }

    public OmxIndex assertName(String extName) {
        if (!this.name.equals(extName)) {
            throw new IllegalArgumentException("Can't use index of " + this.name + " to access " + extName);
        }
        return this;
    }

    @Override
    public int getVersionMajor() {
        return this.majorVersion;
    }

    @Override
    public int getVersionMinor() {
        return this.minorVersion;
    }
}

