/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx.message;

import android.os.Build;

public enum OmxMessageType {
    EVENT(16, 12),
    EMPTY_BUFFER_DONE(16, 4),
    FILL_BUFFER_DONE(16, 24 + (Build.VERSION.SDK_INT < 21 ? 8 : 0)),
    FRAME_RENDERED(23, 16);

    private static int maxSize;
    final int apiLevel;
    final int size;

    private OmxMessageType(int apiLevel, int size) {
        this.apiLevel = apiLevel;
        this.size = size;
    }

    private boolean supported() {
        return Build.VERSION.SDK_INT >= this.apiLevel;
    }

    public static int getSize() {
        if (maxSize == 0) {
            for (OmxMessageType type : OmxMessageType.values()) {
                if (!type.supported() || maxSize >= type.size) continue;
                maxSize = type.size;
            }
        }
        return maxSize;
    }
}

