/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import android.os.Bundle;
import com.skype.android.video.hw.codec.AbstractMediaCodec;
import com.skype.android.video.hw.codec.encoder.control.AbstractVideoEncoderControl;
import com.skype.android.video.hw.codec.encoder.control.VideoEncoderControlOmx;
import com.skype.android.video.hw.codec.encoder.control.VideoEncoderControlQcAfterNExtension;
import com.skype.android.video.hw.codec.encoder.control.VideoEncoderControlQcExtension;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.Log;

public abstract class AbstractVideoEncoder
extends AbstractMediaCodec {
    private final Bundle setBitrateRequest = new Bundle();
    private final Bundle syncFrameRequest = new Bundle();
    private final Bundle suspendRequest = new Bundle();
    private AbstractVideoEncoderControl encControl = null;
    private final String simpleClassName = this.getClass().getSimpleName();

    protected AbstractVideoEncoder(String codecName) {
        super(codecName, true);
        this.encControl = this.useQCExtension ? new VideoEncoderControlQcExtension(this.mediaCodec) : (this.useQCAfterNougatExtension ? new VideoEncoderControlQcAfterNExtension(this.mediaCodec) : (this.omxWrapper != null ? new VideoEncoderControlOmx(this.mediaCodec, this.omxWrapper) : new AbstractVideoEncoderControl(this.mediaCodec, null){

            @Override
            public void setRcFrameRate(float fps) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void useLTRFrame(int useLTRFrameIdxBitMap) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void setQp(int qp) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void setNumTempLayers(int numTempLayers) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void setBaseLayerPID(int baseLayerPID) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void markLtrFrame(int longTermFrameIdx) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void cleanFrameParams() throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void markParamsTimestamp(long timestamp) throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            @Override
            public void configureFrameParams() throws APINotImplementedException {
                this.LogAndThrowNotImplemented(AbstractVideoEncoder.this.simpleClassName + '#' + DebugUtils.getMethodName());
            }

            private void LogAndThrowNotImplemented(String methodName) throws APINotImplementedException {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", methodName + " is not implemented (neither QC nor OMX extensions are available)");
                }
                throw new APINotImplementedException(methodName, "neither QC nor OMX extensions are available");
            }
        }));
    }

    public void setRcFrameRate(float fps) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        this.encControl.setRcFrameRate(fps);
    }

    @SuppressLint(value={"NewApi"})
    public void setBitrate(int bitrate) {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (bitrate > Integer.MAX_VALUE || bitrate < 0) {
            throw new IllegalArgumentException("bitrate out of range");
        }
        this.setBitrateRequest.putInt("video-bitrate", bitrate);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Setting " + this.setBitrateRequest + " on " + this.mediaCodec);
        }
        this.mediaCodec.setParameters(this.setBitrateRequest);
    }

    @SuppressLint(value={"NewApi"})
    public void requestSyncFrame() {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        this.syncFrameRequest.putInt("request-sync", 0);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Setting " + this.syncFrameRequest + " on " + this.mediaCodec);
        }
        this.mediaCodec.setParameters(this.syncFrameRequest);
    }

    @SuppressLint(value={"NewApi"})
    public void suspend() {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        this.suspendRequest.putInt("drop-input-frames", 1);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Setting " + this.suspendRequest + " on " + this.mediaCodec);
        }
        this.mediaCodec.setParameters(this.suspendRequest);
    }

    public void setQp(int qp) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (qp < 0 || qp > 51) {
            throw new IllegalArgumentException("QP out of range");
        }
        this.encControl.setQp(qp);
    }

    public void setNumTempLayers(int numTempLayers) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (numTempLayers > 6 || numTempLayers < 1) {
            throw new IllegalArgumentException("numTempLayers out of range [1;6]");
        }
        this.encControl.setNumTempLayers(numTempLayers);
    }

    public void setBaseLayerPID(int baseLayerPID) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (baseLayerPID < 0 || baseLayerPID > 63) {
            throw new IllegalArgumentException("baseLayerPID out of range [1;6]");
        }
        this.encControl.setBaseLayerPID(baseLayerPID);
    }

    public void markLtrFrame(int longTermFrameIdx) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (longTermFrameIdx < 0 || longTermFrameIdx > 4) {
            throw new IllegalArgumentException("longTermFrameIdx out of range [0;4]");
        }
        this.encControl.markLtrFrame(longTermFrameIdx);
    }

    public void useLTRFrame(int useLTRFrameIdxBitMap) throws APINotImplementedException {
        if (!this.isOpen()) {
            throw new IllegalStateException("closed");
        }
        if (useLTRFrameIdxBitMap < 0 || useLTRFrameIdxBitMap > 63) {
            throw new IllegalArgumentException("useLTRFrameIdxBitMap out of range [0;63]");
        }
        this.encControl.useLTRFrame(useLTRFrameIdxBitMap);
    }

    public void cleanFrameParams() throws APINotImplementedException {
        if (this.useQCExtension || this.useQCAfterNougatExtension) {
            this.encControl.cleanFrameParams();
        }
    }

    public void markParamsTimestamp(long timestamp) throws APINotImplementedException {
        if (this.useQCExtension || this.useQCAfterNougatExtension) {
            this.encControl.markParamsTimestamp(timestamp);
        }
    }

    public void configureFrameParams() throws APINotImplementedException {
        if (this.useQCExtension || this.useQCAfterNougatExtension) {
            this.encControl.configureFrameParams();
        }
    }

    @Override
    protected void doConfigureMediaFormat(MediaFormat mediaFormat, VideoFormat format) {
        this.encControl.doConfigureMediaFormat(mediaFormat, format);
    }

    @Override
    protected void doConfigureDynamic(VideoFormat format) {
        int numTemporalLayers = format.getSvcAlways() ? Math.min(Math.max(format.getNumLayers(), 1), 2) : 0;
        int baseLayerPID = Math.min(Math.max(format.getBaseLayerPriorityId(), 0), 63);
        try {
            this.encControl.setNumTempLayers(numTemporalLayers);
            this.encControl.setBaseLayerPID(baseLayerPID);
        }
        catch (APINotImplementedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected int doGetMediaCodecFlags() {
        return 1;
    }

    public static class APINotImplementedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String failedApiName;

        public APINotImplementedException(String failedApiName, String detailMessage) {
            super(detailMessage);
            this.failedApiName = failedApiName;
        }

        public String getFailedApiName() {
            return this.failedApiName;
        }
    }
}

