/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera;

import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.AbstractVideoEncoder;
import com.skype.android.video.hw.codec.encoder.camera.SurfaceObserver;
import com.skype.android.video.hw.format.ColorFormat;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.Log;
import java.lang.ref.WeakReference;

public class VideoCameraEncoder
extends AbstractVideoEncoder {
    private Surface inputSurface;
    private WeakReference<SurfaceObserver> weakRefSurfaceObserver;
    private final String simpleClassName = this.getClass().getSimpleName();

    public VideoCameraEncoder(String codecName) {
        super(codecName);
    }

    @Override
    public void configure(Object userData, VideoFormat videoFormat, boolean checkHwApiVersioning) {
        if (!videoFormat.getColorFormat().equals(ColorFormat.SURFACE)) {
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": " + ColorFormat.SURFACE + " color format is expected");
            }
            videoFormat.setColorFormat(ColorFormat.SURFACE);
        }
        this.weakRefSurfaceObserver = new WeakReference<SurfaceObserver>((SurfaceObserver)userData);
        SurfaceObserver surfaceObserver = (SurfaceObserver)this.weakRefSurfaceObserver.get();
        super.configure(surfaceObserver, videoFormat, checkHwApiVersioning);
        this.inputSurface = this.mediaCodec.createInputSurface();
        if (surfaceObserver != null) {
            surfaceObserver.attachSurface(this.inputSurface, videoFormat.getResolution());
        } else {
            this.inputSurface.release();
            this.inputSurface = null;
        }
    }

    @Override
    public void close() {
        SurfaceObserver surfaceObserver = (SurfaceObserver)this.weakRefSurfaceObserver.get();
        if (surfaceObserver != null) {
            surfaceObserver.detachSurface();
        } else if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        super.close();
    }

    public OutputFrame encode(long timeoutUs) {
        return super.drainCodec(timeoutUs, false);
    }
}

