/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.capture;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerSource;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.VirtualSourceGenerator;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class VirtualCaptureSource
implements CapturerSource {
    private final Object surfaceMutex = new Object();
    private final Object activeTaskMutex = new Object();
    private final Object nativeObjMutex = new Object();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Runnable runner = new Runner();
    private long nativeObj;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int framerate;
    private ScheduledFuture<?> activeTask;
    private ByteBuffer frameData;
    private Resolution sourceResolution;
    private int frameSize;
    private volatile long timestamp;
    private VirtualSourceGenerator virtualSource;
    private final boolean useRunner;
    private final String simpleClassName = this.getClass().getSimpleName();

    public VirtualCaptureSource(boolean userunner) throws GLException {
        this.useRunner = userunner;
        this.nativeObj = this.createNative(this.useRunner);
        Log.i("SLIQ", this.simpleClassName + ": Created. nativeObj=0x" + Long.toHexString(this.nativeObj));
        this.virtualSource = new VirtualSourceGenerator();
        this.timestamp = 10000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Closing. nativeObj=0x" + Long.toHexString(this.nativeObj));
        }
        Object object = this.activeTaskMutex;
        synchronized (object) {
            if (this.activeTask != null) {
                this.stop();
            }
        }
        this.setSurfaceTexture(null);
        object = this.nativeObjMutex;
        synchronized (object) {
            if (this.nativeObj != 0L) {
                this.deleteNative(this.nativeObj);
                this.nativeObj = 0L;
            }
        }
    }

    @Override
    public void start() throws CapturerException {
        block3: {
            Log.i("SLIQ", this.simpleClassName + ": Starting. nativeObj=0x" + Long.toHexString(this.nativeObj));
            try {
                this.virtualSource.setup();
            }
            catch (GLException e) {
                if (!Log.isLoggable("SLIQ", 6)) break block3;
                Log.e("SLIQ", "Exception caught!", e);
            }
        }
        if (this.useRunner) {
            this.startRunner();
        }
    }

    @Override
    public void stop() {
        block3: {
            Log.i("SLIQ", this.simpleClassName + ": Stopping. nativeObj=0x" + Long.toHexString(this.nativeObj));
            if (this.useRunner) {
                this.stopRunner();
            }
            try {
                this.virtualSource.close();
            }
            catch (GLException e) {
                if (!Log.isLoggable("SLIQ", 6)) break block3;
                Log.e("SLIQ", "Exception caught!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        Object object = this.surfaceMutex;
        synchronized (object) {
            if (null != surfaceTexture) {
                if (this.surface != null) {
                    this.surface.release();
                    this.surface = null;
                }
                if (this.surfaceTexture != null) {
                    this.surfaceTexture.release();
                }
                this.surfaceTexture = surfaceTexture;
                if (surfaceTexture != null) {
                    this.surface = new Surface(this.surfaceTexture);
                }
                surfaceTexture.setDefaultBufferSize(this.sourceResolution.getWidth(), this.sourceResolution.getHeight());
                this.virtualSource.setResolution(this.sourceResolution);
                this.virtualSource.setSurface(this.surface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResolution(Resolution resolution) throws CapturerException {
        Object object = this.surfaceMutex;
        synchronized (object) {
            this.sourceResolution = resolution;
            this.frameSize = 4 * this.sourceResolution.getWidth() * this.sourceResolution.getHeight();
            this.frameData = ByteBuffer.allocateDirect(this.frameSize);
        }
        object = this.nativeObjMutex;
        synchronized (object) {
            this.setResolution(this.nativeObj, resolution.getWidth(), resolution.getHeight(), this.frameData);
            this.virtualSource.setResolution(resolution);
            if (this.surfaceTexture != null) {
                this.surfaceTexture.setDefaultBufferSize(this.sourceResolution.getWidth() + 15 & 0xFFF0, this.sourceResolution.getHeight() + 15 & 0xFFF0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFramerate(int framerate) throws CapturerException {
        this.framerate = framerate;
        Object object = this.activeTaskMutex;
        synchronized (object) {
            if (this.activeTask != null) {
                this.stop();
                this.start();
            }
        }
    }

    @Override
    public void configure(Resolution resolution, int framerate) throws CapturerException {
        this.setResolution(resolution);
        this.setFramerate(framerate);
    }

    @Override
    public long getNativeCtx() {
        return this.nativeObj;
    }

    @Override
    public void unlock() {
        this.unlock(this.nativeObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunner() {
        Object object = this.activeTaskMutex;
        synchronized (object) {
            if (this.activeTask != null) {
                throw new IllegalStateException("already running");
            }
            long periodUs = 1000000000 / this.framerate;
            this.activeTask = this.executor.scheduleAtFixedRate(this.runner, 0L, periodUs, TimeUnit.MICROSECONDS);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + ": Runner task scheduled with period " + (float)periodUs / 1000.0f + " ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRunner() {
        Object object = this.activeTaskMutex;
        synchronized (object) {
            if (this.activeTask == null) {
                throw new IllegalStateException("not running");
            }
            if (!this.activeTask.cancel(false)) {
                if (Log.isLoggable("SLIQ", 5)) {
                    Log.w("SLIQ", this.simpleClassName + ": Could not cancel active task");
                }
            } else {
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.simpleClassName + ": Runner task canceled");
                }
                this.activeTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrame() throws GLException {
        Object object = this.surfaceMutex;
        synchronized (object) {
            try {
                this.virtualSource.renderOneFrame(this.frameData, this.timestamp);
            }
            catch (Throwable e) {
                Log.e("SLIQ", "", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameAvailableCallback() {
        block5: {
            Object object = this.nativeObjMutex;
            synchronized (object) {
                this.timestamp = this.getFrame(this.nativeObj);
            }
            try {
                this.writeFrame();
            }
            catch (GLException e) {
                if (!Log.isLoggable("SLIQ", 6)) break block5;
                Log.e("SLIQ", "Exception caught!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolutionChangedCallback(int width, int height) {
        Object object = this.nativeObjMutex;
        synchronized (object) {
            block5: {
                this.sourceResolution = new Resolution(width, height);
                try {
                    this.setResolution(this.sourceResolution);
                }
                catch (CapturerException e) {
                    if (!Log.isLoggable("SLIQ", 6)) break block5;
                    Log.e("SLIQ", "Exception caught!", e);
                }
            }
        }
    }

    private native long createNative(boolean var1);

    private native void deleteNative(long var1);

    private native long getFrame(long var1);

    private native void setResolution(long var1, int var3, int var4, ByteBuffer var5);

    private native void unlock(long var1);

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                Object object = VirtualCaptureSource.this.nativeObjMutex;
                synchronized (object) {
                    VirtualCaptureSource.this.timestamp = VirtualCaptureSource.this.getFrame(VirtualCaptureSource.this.nativeObj);
                }
                try {
                    VirtualCaptureSource.this.writeFrame();
                }
                catch (GLException e) {
                    if (!Log.isLoggable("SLIQ", 6)) break block5;
                    Log.e("SLIQ", "Exception caught!", e);
                }
            }
        }
    }
}

