/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLObjectHandle;
import com.skype.android.video.hw.codec.encoder.camera.gl.EGLUtils;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;

public class Context
implements Closeable {
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig eglConfig;
    private static String simpleClassName = Context.class.getSimpleName();

    public Context(EGLDisplay display, int[] eglConfigAttributes) throws GLException {
        this(display, EGL14.EGL_NO_CONTEXT, eglConfigAttributes);
    }

    public Context(Context sharedContext, int[] eglConfigAttributes) throws GLException {
        this(sharedContext.getEGLDisplay(), sharedContext.getEGLContext(), eglConfigAttributes);
    }

    private Context(EGLDisplay soleDisplay, EGLContext eglSharedContext, int[] eglConfigAttributes) throws GLException {
        this.eglDisplay = soleDisplay;
        this.eglConfig = Context.chooseConfig(this.eglDisplay, eglConfigAttributes);
        this.eglContext = Context.createContext(this.eglDisplay, this.eglConfig, eglSharedContext);
    }

    @Override
    public void close() {
        if (this.eglContext != EGL14.EGL_NO_CONTEXT) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Destroying EGL context");
            }
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            this.eglContext = EGL14.EGL_NO_CONTEXT;
        }
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    public boolean isCurrent() {
        if (this.eglContext == EGL14.EGL_NO_CONTEXT) {
            throw new IllegalStateException("closed");
        }
        return this.eglContext.equals((Object)EGL14.eglGetCurrentContext());
    }

    public EGLContext getEGLContext() {
        if (this.eglContext == EGL14.EGL_NO_CONTEXT) {
            throw new IllegalStateException("closed");
        }
        return this.eglContext;
    }

    public EGLDisplay getEGLDisplay() {
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new IllegalStateException("closed");
        }
        return this.eglDisplay;
    }

    public EGLConfig getEGLConfig() {
        if (this.eglConfig == null) {
            throw new IllegalStateException("closed");
        }
        return this.eglConfig;
    }

    private static EGLConfig chooseConfig(EGLDisplay display, int[] attributes) throws GLException {
        EGLConfig[] eglConfigs = new EGLConfig[1];
        int[] numEglConfigs = new int[1];
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Choosing EGL config");
        }
        EGL14.eglChooseConfig((EGLDisplay)display, (int[])attributes, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)eglConfigs.length, (int[])numEglConfigs, (int)0);
        EGLUtils.validate("Failed to choose EGL config.");
        return eglConfigs[0];
    }

    private static EGLContext createContext(EGLDisplay display, EGLConfig eglConfig, EGLContext sharedContext) throws GLException {
        int[] attributes = new int[]{12440, 2, 12344};
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Creating EGL context");
        }
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)display, (EGLConfig)eglConfig, (EGLContext)sharedContext, (int[])attributes, (int)0);
        EGLUtils.validate("Failed to create EGL context.");
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eglConfig != null ? this.eglConfig.hashCode() : 0);
        result = 31 * result + (this.eglContext != null ? this.eglContext.hashCode() : 0);
        result = 31 * result + (this.eglDisplay != null ? this.eglDisplay.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        if (this.eglConfig == null ? other.eglConfig != null : !this.eglConfig.equals((Object)other.eglConfig)) {
            return false;
        }
        if (this.eglContext == null ? other.eglContext != null : !this.eglContext.equals((Object)other.eglContext)) {
            return false;
        }
        return !(this.eglDisplay == null ? other.eglDisplay != null : !this.eglDisplay.equals((Object)other.eglDisplay));
    }

    public String toString() {
        return simpleClassName + " [display=" + EGLUtils.idStringOf((EGLObjectHandle)this.eglDisplay) + ", context=" + EGLUtils.idStringOf((EGLObjectHandle)this.eglContext) + ", config=" + EGLUtils.idStringOf((EGLObjectHandle)this.eglConfig) + "]";
    }
}

