/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.opengl.GLES20;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.Shader;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;

class Program
implements Closeable {
    private int id;
    private Shader vertexShader;
    private Shader fragmentShader;
    private static String simpleClassName = Program.class.getSimpleName();

    public Program(String vertexShaderSource, String fragmentShaderSource) throws GLException {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Creating new GL program ");
        }
        if ((this.id = GLES20.glCreateProgram()) == 0) {
            throw new GLException("Failed to create GL program.", GLES20.glGetError());
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": GL program " + this.id + " created");
        }
        this.vertexShader = new Shader(35633, vertexShaderSource);
        this.fragmentShader = new Shader(35632, fragmentShaderSource);
        this.attachShader(this.vertexShader);
        this.attachShader(this.fragmentShader);
        this.link();
    }

    @Override
    public void close() {
        if (this.vertexShader != null) {
            this.vertexShader.close();
            this.vertexShader = null;
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.close();
            this.fragmentShader = null;
        }
        if (this.id != 0) {
            int error;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Deleting GL program " + this.id);
            }
            GLES20.glDeleteProgram((int)this.id);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": GL program " + this.id + " deleted");
            }
            if ((error = GLES20.glGetError()) != 0 && Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", simpleClassName + ": Failed to delete GL program " + this.id);
            }
            this.id = 0;
        }
    }

    public void install() throws GLException {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Installing GL program " + this.id);
        }
        GLES20.glUseProgram((int)this.id);
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new GLException("Failed install GL program " + this.id, error);
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": GL program " + this.id + " installed");
        }
    }

    public int getAttribLocation(String name) throws GLException {
        int loc = GLES20.glGetAttribLocation((int)this.id, (String)name);
        if (loc < 0) {
            throw new GLException("Failed get location of the attribute '" + name + "' within GL program " + this.id);
        }
        return loc;
    }

    public int getUniformLocation(String name) throws GLException {
        int loc = GLES20.glGetUniformLocation((int)this.id, (String)name);
        if (loc < 0) {
            throw new GLException("Failed get location of the uniform '" + name + "' within GL program " + this.id);
        }
        return loc;
    }

    private void attachShader(Shader shader) throws GLException {
        int error;
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Attaching shader " + shader.getId() + " to GL program " + this.id);
        }
        GLES20.glAttachShader((int)this.id, (int)shader.getId());
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Shader " + shader.getId() + " attached to GL program " + this.id);
        }
        if ((error = GLES20.glGetError()) != 0) {
            throw new GLException("Failed to attach shader" + shader.getId() + " to GL program " + this.id, error);
        }
    }

    private void link() throws GLException {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Linking GL program " + this.id);
        }
        GLES20.glLinkProgram((int)this.id);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": GL program " + this.id + " linkled");
        }
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)this.id, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Failed to link GL program " + this.id + "\n" + GLES20.glGetProgramInfoLog((int)this.id));
            }
            throw new GLException("Failed to link GL program" + this.id);
        }
    }
}

